/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.git;

import com.google.inject.Inject;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.FS;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshProvider
implements Provider<TransportConfigCallback> {
    private static final Logger LOG = LoggerFactory.getLogger(SshProvider.class);
    @Inject(optional=true)
    @Named(value="taomubox.git.ssh.keypath")
    private String sshkeyPath;

    public TransportConfigCallback get() {
        LOG.info("Guice\u4eceSshProvider\u4e2d\u83b7\u53d6TransportConfigCallback\u5b9e\u4f8b");
        return new TransportConfigCallback(){

            public void configure(Transport transport) {
                SshTransport sshTransport = (SshTransport)transport;
                JschConfigSessionFactory jcsf = new JschConfigSessionFactory(){

                    public void configure(OpenSshConfig.Host host, Session session) {
                        session.setConfig("StrictHostKeyChecking", "no");
                    }

                    public JSch createDefaultJSch(FS fs) {
                        try {
                            JSch jSch = super.createDefaultJSch(fs);
                            LOG.info("JschConfigSessionFactory\u8bbe\u7f6esshkeypath:{}", (Object)SshProvider.this.sshkeyPath);
                            jSch.addIdentity(SshProvider.this.sshkeyPath);
                            return jSch;
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                SshSessionFactory.setInstance((SshSessionFactory)new JschConfigSessionFactory(){

                    public void configure(OpenSshConfig.Host host, Session session) {
                        session.setConfig("StrictHostKeyChecking", "no");
                    }

                    public JSch createDefaultJSch(FS fs) {
                        try {
                            JSch jSch = super.createDefaultJSch(fs);
                            LOG.info("JschConfigSessionFactory\u8bbe\u7f6esshkeypath:{}", (Object)SshProvider.this.sshkeyPath);
                            jSch.addIdentity(SshProvider.this.sshkeyPath);
                            return jSch;
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                });
                sshTransport.setSshSessionFactory((SshSessionFactory)jcsf);
            }
        };
    }
}

