/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.git;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cool.taomu.box.git.entity.GitCommitInfoEntity;
import cool.taomu.box.git.entity.GitFileHistoryContentEntity;
import cool.taomu.box.utils.FileTools;
import cool.taomu.box.utils.inter.ICallback;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Accessors
public class JGitTools {
    private static final Logger LOG = LoggerFactory.getLogger(JGitTools.class);
    @Inject(optional=true)
    private TransportConfigCallback ssh;
    @Inject(optional=true)
    private CredentialsProvider cp;
    @Inject(optional=true)
    @Named(value="taomubox.git.repository")
    private String repository = "./repository";
    private boolean isAutoCommit = true;
    private String remoteRepository = "";
    private String branch = "master";
    private static final String regex = "^(?:git@|ssh?:\\/\\/|https?:\\/\\/)(?:[a-zA-Z0-9\\-.]+\\.)+[a-zA-Z]{2,}(?::\\d+)?(?:\\/[a-zA-Z0-9\\-._\\/]+(?:\\.git)?(?:\\/[a-zA-Z0-9\\-._\\/]*)?)?$";

    public void setRepository(String repository) {
        this.setRepository("", repository);
    }

    public void setRepository(String basePath, String repository) {
        Perl5Util p5 = new Perl5Util();
        boolean _match = p5.match(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"/", regex, "/"})), (CharSequence)""), repository);
        if (_match) {
            this.remoteRepository = repository;
            int _lastIndexOf = repository.lastIndexOf("/");
            int _plus = _lastIndexOf + 1;
            this.repository = repository.substring(_plus, repository.lastIndexOf(".git"));
        } else {
            this.repository = repository;
        }
        boolean _isNotBlank = StringUtils.isNotBlank((CharSequence)basePath);
        if (_isNotBlank) {
            this.repository = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{basePath, this.repository})), (CharSequence)File.separator);
        }
        LOG.info("GIT\u8fdc\u7a0b\u4ed3\u5e93\u5730\u5740:{}", (Object)this.remoteRepository);
        LOG.info("GIT\u672c\u5730\u4ed3\u5e93\u5730\u5740:{}", (Object)this.repository);
    }

    public static void main(String[] args) {
        JGitTools r = new JGitTools();
        r.setRepository("http://example.com/path/to/repo.git");
    }

    private void credentials(TransportCommand<?, ?> command) {
        if (this.ssh != null) {
            command.setTransportConfigCallback(this.ssh);
        } else if (this.cp != null) {
            command.setCredentialsProvider(this.cp);
        } else {
            LOG.info("GIT\u767b\u9646credentials\u662f\u7a7a\u7684");
        }
    }

    private File getRepository(String remoteRepository) {
        String _join;
        File file;
        boolean _exists;
        boolean _not;
        String projectName = remoteRepository;
        boolean _contains = remoteRepository.contains("/");
        if (_contains) {
            int _lastIndexOf = remoteRepository.lastIndexOf("/");
            int _plus = _lastIndexOf + 1;
            projectName = remoteRepository.substring(_plus);
        }
        boolean bl = _not = !(_exists = (file = new File(_join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{this.repository, projectName})), (CharSequence)File.separator))).exists());
        if (_not) {
            LOG.info("\u521b\u5efa\u76ee\u5f55:{}", (Object)file.getAbsolutePath());
            file.mkdirs();
        }
        return file;
    }

    public boolean isReprositoryExists() {
        boolean _xblockexpression = false;
        String _trim = this.repository.trim();
        String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
        File file = new File(_join);
        _xblockexpression = file.exists();
        return _xblockexpression;
    }

    public void init() {
        try {
            String _trim = this.repository.trim();
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
            File file = new File(_join);
            Repository createRepo = FileRepositoryBuilder.create((File)file);
            if (createRepo != null) {
                createRepo.create();
            }
            createRepo.close();
            LOG.info("\u521d\u59cb\u5316\u672c\u5730\u4ed3\u5e93:{}", (Object)file.getAbsolutePath());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void rmAndCommit(String msg, ICallback<RmCommand> call) {
        if (call != null) {
            try {
                String _trim = this.repository.trim();
                String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
                File file = new File(_join);
                LOG.info("\u6253\u5f00GIT\u4ed3\u5e93{}", (Object)file.getAbsolutePath());
                Git git = Git.open((File)file);
                RmCommand rm = git.rm();
                call.call((Object)rm);
                rm.call();
                if (this.isAutoCommit) {
                    RevCommit commit = git.commit().setMessage((String)StringUtils.defaultIfBlank((CharSequence)msg, (CharSequence)"\u65e0\u4fe1\u606f")).call();
                    LOG.info("\u5220\u9664\u63d0\u4ea4\u7684id:{}", (Object)commit.getName());
                }
                git.close();
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    ex.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public void addAndCommit(String msg, ICallback<AddCommand> call) {
        if (call != null) {
            try {
                String _trim = this.repository.trim();
                String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
                File file = new File(_join);
                LOG.info("\u6253\u5f00GIT\u4ed3\u5e93{}", (Object)file.getAbsolutePath());
                Git git = Git.open((File)file);
                AddCommand add = git.add();
                call.call((Object)add);
                add.call();
                if (this.isAutoCommit) {
                    RevCommit commit = git.commit().setMessage((String)StringUtils.defaultIfBlank((CharSequence)msg, (CharSequence)"\u65e0\u4fe1\u606f")).call();
                    LOG.info("\u6dfb\u52a0\u63d0\u4ea4\u7684id:{}", (Object)commit.getName());
                }
                git.close();
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    ex.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public void getCommitIds(Integer num, ICallback<GitCommitInfoEntity> call) {
        try {
            LOG.info("\u83b7\u53d6commit\u5386\u53f2");
            String _trim = this.repository.trim();
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
            File _file = new File(_join);
            Git git = Git.open((File)_file);
            Repository _repository = git.getRepository();
            RevWalk walk = new RevWalk(_repository);
            RevCommit head = walk.parseCommit((AnyObjectId)git.getRepository().resolve("HEAD"));
            walk.reset();
            walk.markStart(head);
            List walkList = IterableExtensions.toList((Iterable)walk);
            LOG.info("\u83b7\u53d6\u5230{}\u6761commit id", (Object)walkList.size());
            if (num != null && call != null) {
                int size = Math.min(num, walkList.size());
                Consumer<RevCommit> _function = it -> {
                    GitCommitInfoEntity entity = new GitCommitInfoEntity();
                    entity.setId(it.getName());
                    Date _when = it.getCommitterIdent().getWhen();
                    DateTime _dateTime = new DateTime((Object)_when);
                    entity.setTime(_dateTime);
                    LOG.info("commit id:{}", (Object)entity.toString());
                    call.call((Object)entity);
                };
                walkList.subList(0, size).forEach(_function);
            } else if (call != null) {
                Consumer<RevCommit> _function_1 = it -> {
                    GitCommitInfoEntity entity = new GitCommitInfoEntity();
                    entity.setId(it.getName());
                    Date _when = it.getCommitterIdent().getWhen();
                    DateTime _dateTime = new DateTime((Object)_when);
                    entity.setTime(_dateTime);
                    LOG.info("commit id:{}", (Object)it.getId());
                    call.call((Object)entity);
                };
                walkList.forEach(_function_1);
            }
            walk.dispose();
            git.close();
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public void retrieveFileContent(String filePath, List<String> commitIds, ICallback<GitFileHistoryContentEntity> call) {
        try {
            String _trim = this.repository.trim();
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
            File _file = new File(_join);
            Git git = Git.open((File)_file);
            Repository _repository = git.getRepository();
            RevWalk walk = new RevWalk(_repository);
            boolean _isNotBlank = StringUtils.isNotBlank((CharSequence)filePath);
            if (_isNotBlank) {
                Consumer<String> _function = commitId -> {
                    try {
                        RevCommit commit = walk.parseCommit((AnyObjectId)git.getRepository().resolve(commitId));
                        String _trim_1 = this.repository.trim();
                        String _plus = _trim_1 + File.separator;
                        String fpath = filePath.replace(_plus, "").replace(File.separator, "/");
                        this.handleCommit(git, (String)commitId, commit, fpath, walk, call);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                commitIds.forEach(_function);
            } else {
                ICallback _function_1 = it -> {
                    if (it.isFile() && !it.getAbsolutePath().contains(".git")) {
                        Consumer<String> _function_2 = commitId -> {
                            try {
                                RevCommit commit = walk.parseCommit((AnyObjectId)git.getRepository().resolve(commitId));
                                String _absolutePath = it.getAbsolutePath();
                                String _trim_1 = this.repository.trim();
                                String _plus = _trim_1 + File.separator;
                                String fpath = _absolutePath.replace(_plus, "").replace(File.separator, "/");
                                this.handleCommit(git, (String)commitId, commit, fpath, walk, call);
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        };
                        commitIds.forEach(_function_2);
                    }
                };
                FileTools.scannerFile((String)this.repository, (ICallback)_function_1);
            }
            walk.dispose();
            git.close();
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private void handleCommit(final Git git, String commitId, final RevCommit commit, final String filePath, RevWalk walk, ICallback<GitFileHistoryContentEntity> call) {
        try (TreeWalk treeWalk = new Functions.Function0<TreeWalk>(){

            public TreeWalk apply() {
                try {
                    return TreeWalk.forPath((Repository)git.getRepository(), (String)filePath, (RevTree)commit.getTree());
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        }.apply();){
            if (treeWalk != null) {
                ObjectId objectId = treeWalk.getObjectId(0);
                ObjectLoader loader = git.getRepository().open((AnyObjectId)objectId);
                byte[] data = loader.getBytes();
                String content = new String(data, StandardCharsets.UTF_8);
                LOG.info("\u4ece{}\u63d0\u4ea4\u4e2d\u83b7\u53d6{}\u6587\u4ef6\u5185\u5bb9", (Object)commit.getName(), (Object)filePath);
                GitFileHistoryContentEntity gfhc = new GitFileHistoryContentEntity();
                gfhc.setFilePath(filePath);
                gfhc.setContent(content);
                Date _when = commit.getCommitterIdent().getWhen();
                DateTime _dateTime = new DateTime((Object)_when);
                gfhc.setTime(_dateTime);
                gfhc.setCommitId(commitId);
                call.call((Object)gfhc);
            } else {
                LOG.info("\u4ece{}\u63d0\u4ea4\u6ca1\u6709\u53d1\u73b0\u6587\u4ef6{},\u63d0\u53d6\u7ed3\u675f", (Object)commit.getName(), (Object)filePath);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void status(ICallback<Status> call) {
        try {
            LOG.info("\u83b7\u53d6{}\u4ed3\u5e93\u7684\u72b6\u6001\u4fe1\u606f", (Object)this.repository);
            String _trim = this.repository.trim();
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
            final File file = new File(_join);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Status status = git.status().call();
                call.call((Object)status);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String Clone() {
        try {
            LOG.info("\u514b\u9686\u8fdc\u7a0b\u4ed3\u5e93{},\u514b\u9686\u5206\u652f\u6216\u6807\u7b7e{}", (Object)this.remoteRepository, (Object)this.branch);
            File file = new File(this.repository);
            file.mkdirs();
            CloneCommand _cloneRepository = Git.cloneRepository();
            final CloneCommand clone = _cloneRepository.setURI(this.remoteRepository);
            clone.setBare(false);
            clone.setCloneAllBranches(true);
            clone.setBranch(this.branch);
            clone.setDirectory(file);
            this.credentials((TransportCommand<?, ?>)clone);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return clone.call();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                LsRemoteCommand refs = git.lsRemote().setHeads(true).setRemote(this.remoteRepository);
                this.credentials((TransportCommand<?, ?>)refs);
                Collection refs2 = refs.call();
                StringBuffer s = new StringBuffer();
                for (Ref ref : refs2) {
                    s.append(ref.getName());
                    s.append("\n");
                }
                s.append("clone success");
                LOG.info("\u514b\u9686\u5b8c\u6210");
                String string = s.toString();
                return string;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public PullResult pull() {
        try {
            PullResult _xblockexpression = null;
            LOG.info("\u4ece\u4ed3\u5e93 {} pull => {}", (Object)this.remoteRepository, (Object)this.branch);
            String _trim = this.repository.trim();
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
            final File file = new File(_join);
            PullResult _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                PullResult _xblockexpression_1 = null;
                PullCommand _pull = git.pull();
                PullCommand pull = _pull.setRemoteBranchName(this.branch);
                this.credentials((TransportCommand<?, ?>)pull);
                _xtrycatchfinallyexpression = _xblockexpression_1 = pull.call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> remoteBranchList() {
        try {
            final Path tempDir = Files.createTempDirectory("jgit-temp-dir", new FileAttribute[0]);
            ArrayList<String> blist = new ArrayList<String>();
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.init().setDirectory(tempDir.toFile()).call();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                LsRemoteCommand _lsRemote = git.lsRemote();
                LsRemoteCommand cmd = _lsRemote.setRemote(this.remoteRepository);
                this.credentials((TransportCommand<?, ?>)cmd);
                Collection refs = cmd.call();
                Consumer<Ref> _function = ref -> {
                    boolean _startsWith = ref.getName().startsWith("refs/heads/");
                    if (_startsWith) {
                        String branchName = ref.getName().substring("refs/heads/".length());
                        blist.add(branchName);
                    }
                };
                refs.forEach(_function);
            }
            finally {
                FileTools.fileDelete((Path)tempDir);
            }
            return blist;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void checkout(String name) {
        try {
            LOG.info("checkout:{}", (Object)name);
            String _trim = this.repository.trim();
            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
            final File file = new File(_join);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                CheckoutCommand _checkout = git.checkout();
                CheckoutCommand ck = _checkout.setName(name);
                ck.call();
            }
            LOG.info("checkout\u5b8c\u6210");
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String HEAD() {
        String _trim = this.repository.trim();
        String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_trim, ".git"})), (CharSequence)File.separator);
        final File file = new File(_join);
        try (Repository repository = new Functions.Function0<Repository>(){

            public Repository apply() {
                try {
                    return ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(file)).readEnvironment()).findGitDir()).build();
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        }.apply();){
            ObjectId headId = repository.resolve("HEAD");
            String string = headId.name();
            return string;
        }
        catch (Throwable _t) {
            if (!(_t instanceof IOException)) throw Exceptions.sneakyThrow((Throwable)_t);
            IOException e = (IOException)_t;
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String clone(String remoteRepository, boolean isAllBranches, String branchOrTag) {
        try {
            String _xifexpression = null;
            _xifexpression = isAllBranches ? "\u662f" : "\u5426";
            LOG.info("\u514b\u9686\u8fdc\u7a0b\u4ed3\u5e93{},\u662f\u5426\u514b\u9686\u5168\u90e8\u5206\u652f{},\u514b\u9686\u5206\u652f\u6216\u6807\u7b7e{}", new Object[]{remoteRepository, _xifexpression, branchOrTag});
            File file = this.getRepository(remoteRepository);
            file.mkdirs();
            final CloneCommand clone = Git.cloneRepository().setURI(remoteRepository).setBare(false);
            if (isAllBranches) {
                clone.setCloneAllBranches(isAllBranches);
            } else {
                clone.setCloneAllBranches(isAllBranches);
                clone.setBranch(branchOrTag);
            }
            clone.setDirectory(file);
            this.credentials((TransportCommand<?, ?>)clone);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return clone.call();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Collection refs = git.lsRemote().setHeads(true).setRemote(remoteRepository).call();
                StringBuffer s = new StringBuffer();
                for (Ref ref : refs) {
                    s.append(ref.getName());
                    s.append("\n");
                }
                s.append("clone success");
                LOG.info("\u514b\u9686\u5b8c\u6210");
                String string = s.toString();
                return string;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String push(String remoteRepository, String name, String branch) {
        try {
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                PushCommand _push = git.push();
                RefSpec _refSpec = new RefSpec(branch);
                PushCommand push = _push.setRefSpecs(new RefSpec[]{_refSpec}).setRemote(name);
                this.credentials((TransportCommand<?, ?>)push);
                Iterable infos = push.call();
                StringBuffer buffer = new StringBuffer();
                for (PushResult info : infos) {
                    buffer.append(info.getMessages());
                    buffer.append("\n");
                }
                String string = buffer.toString();
                return string;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String fetch(String remoteRepository, String branch) {
        try {
            File file = this.getRepository(remoteRepository);
            RefSpec _refSpec = new RefSpec(branch + ":" + branch);
            FetchCommand fetchCommand = Git.open((File)file).fetch().setRemote(remoteRepository).setRefSpecs(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RefSpec[]{_refSpec})));
            this.credentials((TransportCommand<?, ?>)fetchCommand);
            FetchResult result = fetchCommand.call();
            return result.getMessages();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String fetchAll(String remoteRepository) {
        try {
            LOG.info("fetch\u4ed3\u5e93{}\u5168\u90e8\u5206\u652f", (Object)remoteRepository);
            File file = this.getRepository(remoteRepository);
            Collection refs = Git.lsRemoteRepository().setHeads(true).setRemote(remoteRepository).call();
            StringBuffer log = new StringBuffer("fetch:\n");
            for (Ref ref : refs) {
                String refStr = ref.getName();
                RefSpec _refSpec = new RefSpec(refStr + ":" + refStr);
                FetchCommand fetchCommand = Git.open((File)file).fetch().setRemote(remoteRepository).setRefSpecs(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RefSpec[]{_refSpec})));
                this.credentials((TransportCommand<?, ?>)fetchCommand);
                FetchResult result = fetchCommand.call();
                log.append(result.getMessages());
                log.append("\n");
            }
            log.append("Fetch success");
            LOG.info("fetch\u5b8c\u6210");
            return log.toString();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RevCommit commit(String remoteRepository, String[] files, String msg) {
        try {
            RevCommit _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            RevCommit _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                RevCommit _xblockexpression_1 = null;
                AddCommand addc = git.add();
                Consumer<String> _function = it -> {
                    try {
                        addc.addFilepattern(it).call();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                ((List)Conversions.doWrapArray((Object)files)).forEach(_function);
                _xtrycatchfinallyexpression = _xblockexpression_1 = git.commit().setMessage(msg).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap<String, String> status(String remoteRepository) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Status status = git.status().call();
                map.put("Added", status.getAdded().toString());
                map.put("Changed", status.getChanged().toString());
                map.put("Conflicting", status.getConflicting().toString());
                map.put("ConflictingStageState", status.getConflictingStageState().toString());
                map.put("IgnoredNotInIndex", status.getIgnoredNotInIndex().toString());
                map.put("Missing", status.getMissing().toString());
                map.put("Modified", status.getModified().toString());
                map.put("Removed", status.getRemoved().toString());
                map.put("UntrackedFiles", status.getUntracked().toString());
                map.put("UntrackedFolders", status.getUntrackedFolders().toString());
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref branchCreate(String remoteRepository, String name) {
        try {
            Ref _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            Ref _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                _xtrycatchfinallyexpression = git.branchCreate().setName(name).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public List<String> branchDelete(String remoteRepository, String[] names) {
        try {
            List _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            List _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                _xtrycatchfinallyexpression = git.branchDelete().setBranchNames(names).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref branchRename(String remoteRepository, String oldName, String newName) {
        try {
            Ref _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            Ref _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                _xtrycatchfinallyexpression = git.branchRename().setNewName(newName).setOldName(oldName).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ArrayList<String> branchList(String remoteRepository) {
        return this.branchList(remoteRepository, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<String> branchList(String remoteRepository, ListBranchCommand.ListMode mode) {
        try {
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                ArrayList result = CollectionLiterals.newArrayList();
                ListBranchCommand blist = git.branchList();
                if (mode != null) {
                    blist.setListMode(mode);
                }
                Consumer<Ref> _function = it -> result.add(it.getName());
                blist.call().forEach(_function);
                ArrayList arrayList = result;
                return arrayList;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean isBranchExist(Git git, String bname) {
        try {
            List refs = git.branchList().call();
            for (Ref ref : refs) {
                boolean _contains = ref.getName().contains(bname);
                if (!_contains) continue;
                return true;
            }
            return false;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void checkoutBranch(String remoteRepository, String name) {
        try {
            LOG.info("\u4ece\u4ed3\u5e93 {} checkout \u5206\u652f:{}", (Object)remoteRepository, (Object)name);
            FileRepositoryBuilder _fileRepositoryBuilder = new FileRepositoryBuilder();
            File _file = new File(remoteRepository);
            Repository repo = ((FileRepositoryBuilder)_fileRepositoryBuilder.setGitDir(_file)).build();
            try (Git git = new Git(repo);){
                boolean _isBranchExist = this.isBranchExist(git, name);
                if (_isBranchExist) {
                    git.checkout().setCreateBranch(false).setName(name).call();
                } else {
                    git.checkout().setCreateBranch(true).setName(name).setStartPoint("origin" + name).call();
                }
                git.pull().call();
            }
            LOG.info("checkout\u5b8c\u6210");
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void checkout(String remoteRepository, String name) {
        try {
            LOG.info("\u4ece\u4ed3\u5e93 {} checkout:{}", (Object)remoteRepository, (Object)name);
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                CheckoutCommand _checkout = git.checkout();
                CheckoutCommand ck = _checkout.setName(name);
                ck.call();
            }
            LOG.info("checkout\u5b8c\u6210");
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public MergeResult merge(String remoteRepository, String srcName, String mergeBranch, String mgs) {
        try {
            MergeResult _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            MergeResult _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                MergeResult _xblockexpression_1 = null;
                Ref ref = git.checkout().setName(srcName).call();
                git.checkout().setName(mergeBranch).call();
                MergeCommand _setCommit = git.merge().include(ref).setCommit(true);
                MergeCommand merge = _setCommit.setFastForward(MergeCommand.FastForwardMode.NO_FF);
                merge.setMessage(mgs);
                _xtrycatchfinallyexpression = _xblockexpression_1 = merge.call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public PullResult pull(String remoteRepository, String remoteBranch) {
        try {
            PullResult _xblockexpression = null;
            LOG.info("\u4ece\u4ed3\u5e93 {} pull => {}", (Object)remoteRepository, (Object)remoteBranch);
            final File file = this.getRepository(remoteRepository);
            PullResult _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                PullResult _xblockexpression_1 = null;
                PullCommand _pull = git.pull();
                PullCommand pull = _pull.setRemoteBranchName(remoteBranch);
                this.credentials((TransportCommand<?, ?>)pull);
                _xtrycatchfinallyexpression = _xblockexpression_1 = pull.call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref reset(String remoteRepository, String objectId) {
        try {
            Ref _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            Ref _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Ref _xblockexpression_1 = null;
                Repository _repository = git.getRepository();
                RevWalk walk = new RevWalk(_repository);
                ObjectId objId = git.getRepository().resolve(objectId);
                RevCommit revCommit = walk.parseCommit((AnyObjectId)objId);
                String vision = revCommit.getParent(0).getName();
                _xtrycatchfinallyexpression = _xblockexpression_1 = git.reset().setMode(ResetCommand.ResetType.HARD).setRef(vision).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RevCommit revert(String remoteRepository, String commitId) {
        try {
            RevCommit _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            RevCommit _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                RevCommit _xblockexpression_1 = null;
                Repository _repository = git.getRepository();
                RevWalk walk = new RevWalk(_repository);
                RevCommit revCommit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)commitId));
                _xtrycatchfinallyexpression = _xblockexpression_1 = git.revert().include((AnyObjectId)revCommit).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String logOne(String remoteRepository) {
        try {
            LOG.info("\u4ece\u4ed3\u5e93 {} \u83b7\u53d6\u7b2c\u4e00\u6761\u65e5\u5fd7", (Object)remoteRepository);
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Iterable log;
                Iterable _converted_log = log = git.log().call();
                RevCommit revCommit = ((RevCommit[])Conversions.unwrapArray((Object)_converted_log, RevCommit.class))[0];
                StringBuilder sb = new StringBuilder();
                sb.append(revCommit.getName()).append("\n");
                sb.append(revCommit.getCommitterIdent().getName()).append(":");
                sb.append(revCommit.getCommitterIdent().getEmailAddress()).append("\n");
                sb.append(revCommit.getCommitterIdent().getWhen()).append("\n");
                sb.append(revCommit.getFullMessage()).append("\n");
                String string = sb.toString();
                return string;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> logAll(String remoteRepository) {
        try {
            LOG.info("\u4ece\u4ed3\u5e93 {} \u83b7\u53d6\u6240\u6709\u65e5\u5fd7", (Object)remoteRepository);
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Iterable log = git.log().call();
                ArrayList<String> logs = new ArrayList<String>();
                for (RevCommit revCommit : log) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(revCommit.getName()).append("\n");
                    sb.append(revCommit.getCommitterIdent().getName()).append(":");
                    sb.append(revCommit.getCommitterIdent().getEmailAddress()).append("\n");
                    sb.append(revCommit.getCommitterIdent().getWhen()).append("\n");
                    sb.append(revCommit.getFullMessage()).append("\n");
                    logs.add(sb.toString());
                }
                ArrayList<String> arrayList = logs;
                return arrayList;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean setAutoCommit(boolean b) {
        this.isAutoCommit = b;
        return this.isAutoCommit;
    }

    @Pure
    public TransportConfigCallback getSsh() {
        return this.ssh;
    }

    public void setSsh(TransportConfigCallback ssh) {
        this.ssh = ssh;
    }

    @Pure
    public CredentialsProvider getCp() {
        return this.cp;
    }

    public void setCp(CredentialsProvider cp) {
        this.cp = cp;
    }

    @Pure
    public String getRepository() {
        return this.repository;
    }

    @Pure
    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public void setIsAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    @Pure
    public String getRemoteRepository() {
        return this.remoteRepository;
    }

    public void setRemoteRepository(String remoteRepository) {
        this.remoteRepository = remoteRepository;
    }

    @Pure
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }
}

