package cool.taomu.box.git;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

@SuppressWarnings("all")
public class UPCredentialsProvider implements Provider<CredentialsProvider> {
  @Inject
  @Named("git.username")
  private String username;
  
  @Inject
  @Named("git.pass")
  private String password;
  
  @Override
  public CredentialsProvider get() {
    return new UsernamePasswordCredentialsProvider(this.username, this.password);
  }
}
