/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.git;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GitUtils {
    @Inject
    private TransportConfigCallback ssh;
    @Inject
    private CredentialsProvider cp;
    private final String repository = "./repository";

    private void credentials(TransportCommand<?, ?> command) {
        if (this.ssh != null) {
            command.setTransportConfigCallback(this.ssh);
        } else if (this.cp != null) {
            command.setCredentialsProvider(this.cp);
        }
    }

    private File getRepository(String remoteRepository) {
        String _join;
        File file;
        boolean _exists;
        boolean _not;
        String projectName = remoteRepository;
        boolean _contains = remoteRepository.contains("/");
        if (_contains) {
            int _lastIndexOf = remoteRepository.lastIndexOf("/");
            int _plus = _lastIndexOf + 1;
            projectName = remoteRepository.substring(_plus);
        }
        boolean bl = _not = !(_exists = (file = new File(_join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{this.repository, projectName})), (CharSequence)File.separator))).exists());
        if (_not) {
            file.mkdirs();
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String clone(String remoteRepository, boolean isAllBranches, String branchOrTag) {
        try {
            File file = this.getRepository(remoteRepository);
            file.mkdirs();
            final CloneCommand clone = Git.cloneRepository().setURI(remoteRepository).setBare(false);
            if (isAllBranches) {
                clone.setCloneAllBranches(isAllBranches);
            } else {
                clone.setCloneAllBranches(isAllBranches);
                clone.setBranch(branchOrTag);
            }
            clone.setDirectory(file);
            this.credentials((TransportCommand<?, ?>)clone);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return clone.call();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Collection refs = git.lsRemote().setHeads(true).setRemote(remoteRepository).call();
                StringBuffer s = new StringBuffer();
                for (Ref ref : refs) {
                    s.append(ref.getName());
                    s.append("\n");
                }
                s.append("clone success");
                String string = s.toString();
                return string;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String push(String remoteRepository, String name, String branch) {
        try {
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                PushCommand _push = git.push();
                RefSpec _refSpec = new RefSpec(branch);
                PushCommand push = _push.setRefSpecs(new RefSpec[]{_refSpec}).setRemote(name);
                this.credentials((TransportCommand<?, ?>)push);
                Iterable infos = push.call();
                StringBuffer buffer = new StringBuffer();
                for (PushResult info : infos) {
                    buffer.append(info.getMessages());
                    buffer.append("\n");
                }
                String string = buffer.toString();
                return string;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String fetch(String remoteRepository) {
        try {
            File file = this.getRepository(remoteRepository);
            Collection refs = Git.lsRemoteRepository().setHeads(true).setRemote(remoteRepository).call();
            StringBuffer log = new StringBuffer("fetch:\n");
            for (Ref ref : refs) {
                String refStr = ref.getName();
                RefSpec _refSpec = new RefSpec(refStr + ":" + refStr);
                FetchCommand fetchCommand = Git.open((File)file).fetch().setRemote(remoteRepository).setRefSpecs(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RefSpec[]{_refSpec})));
                this.credentials((TransportCommand<?, ?>)fetchCommand);
                FetchResult result = fetchCommand.call();
                log.append(result.getMessages());
                log.append("\n");
            }
            log.append("Fetch success");
            return log.toString();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RevCommit commit(String remoteRepository, String[] files, String msg) {
        try {
            RevCommit _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            RevCommit _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                RevCommit _xblockexpression_1 = null;
                AddCommand addc = git.add();
                Consumer<String> _function = it -> {
                    try {
                        addc.addFilepattern(it).call();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                ((List)Conversions.doWrapArray((Object)files)).forEach(_function);
                _xtrycatchfinallyexpression = _xblockexpression_1 = git.commit().setMessage(msg).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap<String, String> status(String remoteRepository) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Status status = git.status().call();
                map.put("Added", status.getAdded().toString());
                map.put("Changed", status.getChanged().toString());
                map.put("Conflicting", status.getConflicting().toString());
                map.put("ConflictingStageState", status.getConflictingStageState().toString());
                map.put("IgnoredNotInIndex", status.getIgnoredNotInIndex().toString());
                map.put("Missing", status.getMissing().toString());
                map.put("Modified", status.getModified().toString());
                map.put("Removed", status.getRemoved().toString());
                map.put("UntrackedFiles", status.getUntracked().toString());
                map.put("UntrackedFolders", status.getUntrackedFolders().toString());
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref branchCreate(String remoteRepository, String name) {
        try {
            Ref _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            Ref _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                _xtrycatchfinallyexpression = git.branchCreate().setName(name).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public List<String> branchDelete(String remoteRepository, String[] names) {
        try {
            List _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            List _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                _xtrycatchfinallyexpression = git.branchDelete().setBranchNames(names).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref branchRename(String remoteRepository, String oldName, String newName) {
        try {
            Ref _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            Ref _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                _xtrycatchfinallyexpression = git.branchRename().setNewName(newName).setOldName(oldName).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ArrayList<String> branchList(String remoteRepository) {
        return this.branchList(remoteRepository, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<String> branchList(String remoteRepository, ListBranchCommand.ListMode mode) {
        try {
            final File file = this.getRepository(remoteRepository);
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                ArrayList result = CollectionLiterals.newArrayList();
                ListBranchCommand blist = git.branchList();
                if (mode != null) {
                    blist.setListMode(mode);
                }
                Consumer<Ref> _function = it -> result.add(it.getName());
                blist.call().forEach(_function);
                ArrayList arrayList = result;
                return arrayList;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean isBranchExist(Git git, String bname) {
        try {
            List refs = git.branchList().call();
            for (Ref ref : refs) {
                boolean _contains = ref.getName().contains(bname);
                if (!_contains) continue;
                return true;
            }
            return false;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public PullResult checkoutBranch(String remoteRepository, String name) {
        try {
            PullResult _xblockexpression = null;
            FileRepositoryBuilder _fileRepositoryBuilder = new FileRepositoryBuilder();
            File _file = new File(remoteRepository);
            Repository repo = ((FileRepositoryBuilder)_fileRepositoryBuilder.setGitDir(_file)).build();
            PullResult _xtrycatchfinallyexpression = null;
            try (Git git = new Git(repo);){
                PullResult _xblockexpression_1 = null;
                boolean _isBranchExist = this.isBranchExist(git, name);
                if (_isBranchExist) {
                    git.checkout().setCreateBranch(false).setName(name).call();
                } else {
                    git.checkout().setCreateBranch(true).setName(name).setStartPoint("origin" + name).call();
                }
                _xtrycatchfinallyexpression = _xblockexpression_1 = git.pull().call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref checkout(String remoteRepository, String name) {
        try {
            Ref _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            Ref _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Ref _xblockexpression_1 = null;
                CheckoutCommand _checkout = git.checkout();
                CheckoutCommand ck = _checkout.setName(name);
                _xtrycatchfinallyexpression = _xblockexpression_1 = ck.call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public MergeResult merge(String remoteRepository, String srcName, String mergeBranch, String mgs) {
        try {
            MergeResult _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            MergeResult _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                MergeResult _xblockexpression_1 = null;
                Ref ref = git.checkout().setName(srcName).call();
                git.checkout().setName(mergeBranch).call();
                MergeCommand _setCommit = git.merge().include(ref).setCommit(true);
                MergeCommand merge = _setCommit.setFastForward(MergeCommand.FastForwardMode.NO_FF);
                merge.setMessage(mgs);
                _xtrycatchfinallyexpression = _xblockexpression_1 = merge.call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public PullResult pull(String remoteRepository, String remoteBranch) {
        try {
            PullResult _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            PullResult _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                PullResult _xblockexpression_1 = null;
                PullCommand _pull = git.pull();
                PullCommand pull = _pull.setRemoteBranchName(remoteBranch);
                this.credentials((TransportCommand<?, ?>)pull);
                _xtrycatchfinallyexpression = _xblockexpression_1 = pull.call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Ref reset(String remoteRepository, String objectId) {
        try {
            Ref _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            Ref _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                Ref _xblockexpression_1 = null;
                Repository _repository = git.getRepository();
                RevWalk walk = new RevWalk(_repository);
                ObjectId objId = git.getRepository().resolve(objectId);
                RevCommit revCommit = walk.parseCommit((AnyObjectId)objId);
                String vision = revCommit.getParent(0).getName();
                _xtrycatchfinallyexpression = _xblockexpression_1 = git.reset().setMode(ResetCommand.ResetType.HARD).setRef(vision).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RevCommit revert(String remoteRepository, String commitId) {
        try {
            RevCommit _xblockexpression = null;
            final File file = this.getRepository(remoteRepository);
            RevCommit _xtrycatchfinallyexpression = null;
            try (Git git = new Functions.Function0<Git>(){

                public Git apply() {
                    try {
                        return Git.open((File)file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                RevCommit _xblockexpression_1 = null;
                Repository _repository = git.getRepository();
                RevWalk walk = new RevWalk(_repository);
                RevCommit revCommit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)commitId));
                _xtrycatchfinallyexpression = _xblockexpression_1 = git.revert().include((AnyObjectId)revCommit).call();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

