package cool.taomu.box.git;

import com.google.inject.Inject;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.FS;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class SshProvider implements Provider<TransportConfigCallback> {
  @Inject(optional = true)
  @Named("taomubox.git.ssh.keypath")
  private String sshkeyPath;
  
  @Override
  public TransportConfigCallback get() {
    return new TransportConfigCallback() {
      @Override
      public void configure(final Transport transport) {
        SshTransport sshTransport = ((SshTransport) transport);
        JschConfigSessionFactory jcsf = new JschConfigSessionFactory() {
          @Override
          public void configure(final OpenSshConfig.Host host, final Session session) {
            session.setConfig("StrictHostKeyChecking", "no");
          }
          
          @Override
          public JSch createDefaultJSch(final FS fs) {
            try {
              JSch jSch = super.createDefaultJSch(fs);
              jSch.addIdentity(SshProvider.this.sshkeyPath);
              return jSch;
            } catch (Throwable _e) {
              throw Exceptions.sneakyThrow(_e);
            }
          }
        };
        SshSessionFactory.setInstance(new JschConfigSessionFactory() {
          @Override
          public void configure(final OpenSshConfig.Host host, final Session session) {
            session.setConfig("StrictHostKeyChecking", "no");
          }
          
          @Override
          public JSch createDefaultJSch(final FS fs) {
            try {
              JSch jSch = super.createDefaultJSch(fs);
              jSch.addIdentity(SshProvider.this.sshkeyPath);
              return jSch;
            } catch (Throwable _e) {
              throw Exceptions.sneakyThrow(_e);
            }
          }
        });
        sshTransport.setSshSessionFactory(jcsf);
      }
    };
  }
}
