package cool.taomu.box.git;

import com.google.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

@SuppressWarnings("all")
public class UPCredentialsProvider implements Provider<CredentialsProvider> {
  @Inject(optional = true)
  @Named("taomubox.git.username")
  private String username;
  
  @Inject(optional = true)
  @Named("taomubox.git.passwd")
  private String password;
  
  @Override
  public CredentialsProvider get() {
    return new UsernamePasswordCredentialsProvider(this.username, this.password);
  }
}
