package cool.taomu.box.git;

import com.google.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class UPCredentialsProvider implements Provider<CredentialsProvider> {
  private static final Logger LOG = LoggerFactory.getLogger(UPCredentialsProvider.class);
  
  @Inject(optional = true)
  @Named("taomubox.git.username")
  private String username;
  
  @Inject(optional = true)
  @Named("taomubox.git.passwd")
  private String password;
  
  @Override
  public CredentialsProvider get() {
    UPCredentialsProvider.LOG.info("Guice从UPCredentialsProvider中获取UsernamePasswordCredentialsProvider实例");
    UPCredentialsProvider.LOG.info("用户名:{},密码是否为空:{}", this.username, Boolean.valueOf(StringExtensions.isNullOrEmpty(this.password)));
    return new UsernamePasswordCredentialsProvider(this.username, this.password);
  }
}
