/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.git;

import com.google.inject.Inject;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.FS;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class SshProvider
implements Provider<TransportConfigCallback> {
    @Inject(optional=true)
    @Named(value="taomubox.git.ssh.keypath")
    private String sshkeyPath;

    public TransportConfigCallback get() {
        return new TransportConfigCallback(){

            public void configure(Transport transport) {
                SshTransport sshTransport = (SshTransport)transport;
                JschConfigSessionFactory jcsf = new JschConfigSessionFactory(){

                    public void configure(OpenSshConfig.Host host, Session session) {
                        session.setConfig("StrictHostKeyChecking", "no");
                    }

                    public JSch createDefaultJSch(FS fs) {
                        try {
                            JSch jSch = super.createDefaultJSch(fs);
                            jSch.addIdentity(SshProvider.this.sshkeyPath);
                            return jSch;
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                SshSessionFactory.setInstance((SshSessionFactory)new JschConfigSessionFactory(){

                    public void configure(OpenSshConfig.Host host, Session session) {
                        session.setConfig("StrictHostKeyChecking", "no");
                    }

                    public JSch createDefaultJSch(FS fs) {
                        try {
                            JSch jSch = super.createDefaultJSch(fs);
                            jSch.addIdentity(SshProvider.this.sshkeyPath);
                            return jSch;
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                });
                sshTransport.setSshSessionFactory((SshSessionFactory)jcsf);
            }
        };
    }
}

