/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.guice.ann;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@EqualsHashCode
@ToString
@Accessors
@SuppressWarnings("all")
public class BindersImpl implements Binders, Serializable {
  private Binder[] value;
  
  private String properties;
  
  private Class<? extends com.google.inject.Module>[] installs;
  
  private String[] dependence;
  
  private Binders[] dependenceBind;
  
  public BindersImpl(final Binder[] value) {
    this.value = value;
  }
  
  @Override
  public Class<? extends Annotation> annotationType() {
    return Binders.class;
  }
  
  @Override
  public Binder[] value() {
    return this.value;
  }
  
  @Override
  public String properties() {
    return this.properties;
  }
  
  @Override
  public Class<? extends com.google.inject.Module>[] installs() {
    return this.installs;
  }
  
  @Override
  public String[] dependence() {
    return this.dependence;
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    BindersImpl other = (BindersImpl) obj;
    if (this.value == null) {
      if (other.value != null)
        return false;
    } else if (!Arrays.deepEquals(this.value, other.value))
      return false;
    if (this.properties == null) {
      if (other.properties != null)
        return false;
    } else if (!this.properties.equals(other.properties))
      return false;
    if (this.installs == null) {
      if (other.installs != null)
        return false;
    } else if (!Arrays.deepEquals(this.installs, other.installs))
      return false;
    if (this.dependence == null) {
      if (other.dependence != null)
        return false;
    } else if (!Arrays.deepEquals(this.dependence, other.dependence))
      return false;
    if (this.dependenceBind == null) {
      if (other.dependenceBind != null)
        return false;
    } else if (!Arrays.deepEquals(this.dependenceBind, other.dependenceBind))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.value== null) ? 0 : Arrays.deepHashCode(this.value));
    result = prime * result + ((this.properties== null) ? 0 : this.properties.hashCode());
    result = prime * result + ((this.installs== null) ? 0 : Arrays.deepHashCode(this.installs));
    result = prime * result + ((this.dependence== null) ? 0 : Arrays.deepHashCode(this.dependence));
    return prime * result + ((this.dependenceBind== null) ? 0 : Arrays.deepHashCode(this.dependenceBind));
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("value", this.value);
    b.add("properties", this.properties);
    b.add("installs", this.installs);
    b.add("dependence", this.dependence);
    b.add("dependenceBind", this.dependenceBind);
    return b.toString();
  }
  
  @Pure
  public Binder[] getValue() {
    return this.value;
  }
  
  public void setValue(final Binder[] value) {
    this.value = value;
  }
  
  @Pure
  public String getProperties() {
    return this.properties;
  }
  
  public void setProperties(final String properties) {
    this.properties = properties;
  }
  
  @Pure
  public Class<? extends com.google.inject.Module>[] getInstalls() {
    return this.installs;
  }
  
  public void setInstalls(final Class<? extends com.google.inject.Module>[] installs) {
    this.installs = installs;
  }
  
  @Pure
  public String[] getDependence() {
    return this.dependence;
  }
  
  public void setDependence(final String[] dependence) {
    this.dependence = dependence;
  }
  
  @Pure
  public Binders[] getDependenceBind() {
    return this.dependenceBind;
  }
  
  public void setDependenceBind(final Binders[] dependenceBind) {
    this.dependenceBind = dependenceBind;
  }
}
