/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.guice.util;

import cool.taomu.box.guice.BinderRule;
import cool.taomu.box.guice.ann.Binder;
import cool.taomu.box.guice.ann.Binders;
import cool.taomu.box.guice.entity.BindersEntity;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class TaomuGuiceUitl {
  public static BindersEntity toBinders(final Binders bs) {
    BindersEntity entity = new BindersEntity();
    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(bs.properties());
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      entity.setProperties(bs.properties());
    }
    if (((bs.installs() != null) && (((List<Class<? extends com.google.inject.Module>>)Conversions.doWrapArray(bs.installs())).size() > 0))) {
      entity.setInstalls(bs.installs());
    }
    if (((bs.value() != null) && (((List<Binder>)Conversions.doWrapArray(bs.value())).size() > 0))) {
      entity.setValues(BinderRule.toBinderEntity(bs.value()));
    }
    return entity;
  }
}
