/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.ioc.entity;

import java.util.Arrays;
import java.util.List;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@EqualsHashCode
@SuppressWarnings("all")
public class BindersEntity implements Comparable<BindersEntity> {
  private String name;
  
  private String properties;
  
  private Class<? extends com.google.inject.Module>[] installs;
  
  private List<BinderEntity> values;
  
  @Override
  public int compareTo(final BindersEntity o) {
    return 0;
  }
  
  @Pure
  public String getName() {
    return this.name;
  }
  
  public void setName(final String name) {
    this.name = name;
  }
  
  @Pure
  public String getProperties() {
    return this.properties;
  }
  
  public void setProperties(final String properties) {
    this.properties = properties;
  }
  
  @Pure
  public Class<? extends com.google.inject.Module>[] getInstalls() {
    return this.installs;
  }
  
  public void setInstalls(final Class<? extends com.google.inject.Module>[] installs) {
    this.installs = installs;
  }
  
  @Pure
  public List<BinderEntity> getValues() {
    return this.values;
  }
  
  public void setValues(final List<BinderEntity> values) {
    this.values = values;
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    BindersEntity other = (BindersEntity) obj;
    if (this.name == null) {
      if (other.name != null)
        return false;
    } else if (!this.name.equals(other.name))
      return false;
    if (this.properties == null) {
      if (other.properties != null)
        return false;
    } else if (!this.properties.equals(other.properties))
      return false;
    if (this.installs == null) {
      if (other.installs != null)
        return false;
    } else if (!Arrays.deepEquals(this.installs, other.installs))
      return false;
    if (this.values == null) {
      if (other.values != null)
        return false;
    } else if (!this.values.equals(other.values))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.name== null) ? 0 : this.name.hashCode());
    result = prime * result + ((this.properties== null) ? 0 : this.properties.hashCode());
    result = prime * result + ((this.installs== null) ? 0 : Arrays.deepHashCode(this.installs));
    return prime * result + ((this.values== null) ? 0 : this.values.hashCode());
  }
}
