/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.ioc.guice;

import com.google.common.base.Objects;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.AnnotatedConstantBindingBuilder;
import com.google.inject.binder.ConstantBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.name.Names;
import cool.taomu.box.asm.CreateClass;
import cool.taomu.box.asm.CreateMethod;
import cool.taomu.box.asm.entity.ClassEntity;
import cool.taomu.box.asm.entity.MethodEntity;
import cool.taomu.box.ioc.ann.Binder;
import cool.taomu.box.ioc.entity.BinderEntity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.objectweb.asm.Type;

@SuppressWarnings("all")
public class BinderRule {
  public static ArrayList<BinderEntity> toBinderEntity(final Binder[] binders) {
    int _size = ((List<Binder>)Conversions.doWrapArray(binders)).size();
    final ArrayList<BinderEntity> results = new ArrayList<BinderEntity>(_size);
    final Consumer<Binder> _function = (Binder it) -> {
      BinderEntity entity = new BinderEntity();
      entity.setProvider(it.provider());
      entity.setIn(it.in());
      entity.setValue(it.value());
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.named());
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        entity.setNamed(it.named());
      }
      Class<?> _bind = it.bind();
      boolean _tripleNotEquals = (_bind != null);
      if (_tripleNotEquals) {
        entity.setBind(it.bind());
      }
      if (((it.to() != null) && (it.to() != Void.class))) {
        entity.setTo(it.to());
        final Function1<Class<?>, Boolean> _function_1 = (Class<?> it_1) -> {
          return Boolean.valueOf((it_1.equals(Provider.class) || it_1.equals(javax.inject.Provider.class)));
        };
        Class<?> _findFirst = IterableExtensions.<Class<?>>findFirst(((Iterable<Class<?>>)Conversions.doWrapArray(it.to().getInterfaces())), _function_1);
        boolean _tripleNotEquals_1 = (_findFirst != null);
        if (_tripleNotEquals_1) {
          entity.setProvider(true);
        }
      }
      results.add(entity);
    };
    IterableExtensions.<Binder>filterNull(((Iterable<Binder>)Conversions.doWrapArray(binders))).forEach(_function);
    return results;
  }
  
  public static void rule(final CreateMethod cm, final List<BinderEntity> binders, final HashMap<String, ClassLoader> ccloader) {
    try {
      Method _method = com.google.inject.Binder.class.getMethod("bind", Class.class);
      final MethodEntity bind = new MethodEntity(com.google.inject.Binder.class, _method);
      Method _method_1 = com.google.inject.Binder.class.getMethod("bindConstant");
      final MethodEntity bindConstant = new MethodEntity(com.google.inject.Binder.class, _method_1);
      Method _method_2 = AnnotatedBindingBuilder.class.getMethod("to", Class.class);
      final MethodEntity to = new MethodEntity(AnnotatedBindingBuilder.class, _method_2);
      Method _method_3 = ConstantBindingBuilder.class.getMethod("to", String.class);
      final MethodEntity cto = new MethodEntity(ConstantBindingBuilder.class, _method_3);
      Method _method_4 = AnnotatedBindingBuilder.class.getMethod("toInstance", Object.class);
      final MethodEntity toInstance = new MethodEntity(AnnotatedBindingBuilder.class, _method_4);
      Method _method_5 = LinkedBindingBuilder.class.getMethod("toInstance", Object.class);
      final MethodEntity toInstance2 = new MethodEntity(LinkedBindingBuilder.class, _method_5);
      Method _method_6 = AnnotatedBindingBuilder.class.getMethod("toProvider", Class.class);
      final MethodEntity toProvider = new MethodEntity(AnnotatedBindingBuilder.class, _method_6);
      Method _method_7 = ScopedBindingBuilder.class.getMethod("in", Scope.class);
      final MethodEntity in = new MethodEntity(ScopedBindingBuilder.class, _method_7);
      final Consumer<BinderEntity> _function = (BinderEntity it) -> {
        try {
          if (((it.getBind() != null) && (!it.getBind().equals(Void.class)))) {
            cm.load("binder").ldc(Type.getType(it.getBind())).invokeInterface(bind);
            String _named = it.getNamed();
            boolean _tripleNotEquals = (_named != null);
            if (_tripleNotEquals) {
              cm.ldc(it.getNamed());
              Method _method_8 = Names.class.getMethod("named", String.class);
              MethodEntity _methodEntity = new MethodEntity(Names.class, _method_8);
              cm.invokeStatic(_methodEntity);
              Method _method_9 = AnnotatedBindingBuilder.class.getMethod("annotatedWith", Annotation.class);
              MethodEntity _methodEntity_1 = new MethodEntity(AnnotatedBindingBuilder.class, _method_9);
              cm.invokeInterface(_methodEntity_1);
              if ((it.getBind().equals(String.class) && (!it.getTo().equals(Void.class)))) {
                it.setValue(it.getTo().getName());
              }
              BinderRule.constToInstance(it, cm, toInstance2);
            } else {
              BinderRule.constToInstance(it, cm, toInstance);
            }
            if (((!it.getTo().equals(Void.class)) && (!it.getBind().equals(String.class)))) {
              boolean _isProvider = it.isProvider();
              if (_isProvider) {
                cm.ldc(Type.getType(it.getTo())).invokeInterface(toProvider);
              } else {
                if ((it.getBind().equals(it.getTo()) && (!it.getBind().isInterface()))) {
                  String _replace = UUID.randomUUID().toString().replace("-", "");
                  String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("Taomu", _replace, "Impl")), "");
                  ClassEntity ccc = new ClassEntity("cool.taomu.box.tmp", _join);
                  ccc.setSuperclass(it.getTo().getName().replace(".", "/"));
                  CreateClass c = CreateClass.Class(ccc);
                  c.constructor(it.getTo().getConstructors());
                  c.end();
                  String _packageName = ccc.getPackageName();
                  String _className = ccc.getClassName();
                  String name = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_packageName, _className)), ".");
                  ccloader.put(name, c);
                  cm.ldc(name);
                  String _replace_1 = TaomuGuiceModule.class.getName().replace(".", "/");
                  MethodEntity _methodEntity_2 = new MethodEntity(_replace_1, 
                    "java/lang/Class loadZlass(java/lang/String)", true);
                  cm.invokeStatic(_methodEntity_2);
                  cm.invokeInterface(to);
                } else {
                  cm.ldc(Type.getType(it.getTo())).invokeInterface(to);
                }
              }
              cool.taomu.box.ioc.entity.Scope _in = it.getIn();
              boolean _tripleNotEquals_1 = (_in != cool.taomu.box.ioc.entity.Scope.None);
              if (_tripleNotEquals_1) {
                boolean _equals = it.getIn().equals(cool.taomu.box.ioc.entity.Scope.SINGLETON);
                if (_equals) {
                  cm.getStatic("com/google/inject/Scopes", "SINGLETON", "Lcom/google/inject/Scope;");
                } else {
                  boolean _equals_1 = it.getIn().equals(cool.taomu.box.ioc.entity.Scope.NO_SCOPE);
                  if (_equals_1) {
                    cm.getStatic("com/google/inject/Scopes", "NO_SCOPE", "Lcom/google/inject/Scope;");
                  }
                }
                cm.invokeInterface(in);
              } else {
                cm.pop();
              }
            }
            if ((((it.getNamed() == null) && it.getTo().equals(Void.class)) && (!it.getBind().equals(String.class)))) {
              cm.pop();
            }
          } else {
            String _named_1 = it.getNamed();
            boolean _tripleNotEquals_2 = (_named_1 != null);
            if (_tripleNotEquals_2) {
              cm.load("binder").invokeVirtual(bindConstant);
              cm.ldc(it.getNamed());
              Method _method_10 = Names.class.getMethod("named", String.class);
              MethodEntity _methodEntity_3 = new MethodEntity(Names.class, _method_10);
              cm.invokeStatic(_methodEntity_3);
              Method _method_11 = AnnotatedConstantBindingBuilder.class.getMethod("annotatedWith", Annotation.class);
              MethodEntity _methodEntity_4 = new MethodEntity(AnnotatedConstantBindingBuilder.class, _method_11);
              cm.invokeInterface(_methodEntity_4);
              boolean _equals_2 = it.getValue().equals("");
              if (_equals_2) {
                it.setValue(it.getTo().getName());
              }
              cm.ldc(it.getValue());
              cm.invokeInterface(cto);
            }
          }
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      IterableExtensions.<BinderEntity>filterNull(binders).forEach(_function);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected static CreateMethod constToInstance(final BinderEntity it, final CreateMethod cm, final MethodEntity toInstance) {
    CreateMethod _switchResult = null;
    Class<?> _bind = it.getBind();
    boolean _matched = false;
    if (Objects.equal(_bind, int.class)) {
      _matched=true;
      CreateMethod _xblockexpression = null;
      {
        cm.ldc(it.getValue());
        cm.invokeStatic(Integer.class, "int parseInt(java/lang/String)");
        cm.invokeStatic(Integer.class, "java/lang/Integer valueOf(int)");
        _xblockexpression = cm.invokeInterface(toInstance);
      }
      _switchResult = _xblockexpression;
    }
    if (!_matched) {
      if (Objects.equal(_bind, long.class)) {
        _matched=true;
        CreateMethod _xblockexpression_1 = null;
        {
          cm.ldc(it.getValue());
          cm.invokeStatic(Long.class, "long parseLong(java/lang/String)");
          cm.invokeStatic(Long.class, "java/lang/Long valueOf(long)");
          _xblockexpression_1 = cm.invokeInterface(toInstance);
        }
        _switchResult = _xblockexpression_1;
      }
    }
    if (!_matched) {
      if (Objects.equal(_bind, short.class)) {
        _matched=true;
        CreateMethod _xblockexpression_2 = null;
        {
          cm.ldc(it.getValue());
          cm.invokeStatic(Short.class, "short parseShort(java/lang/String)");
          cm.invokeStatic(Short.class, "java/lang/Short valueOf(short)");
          _xblockexpression_2 = cm.invokeInterface(toInstance);
        }
        _switchResult = _xblockexpression_2;
      }
    }
    if (!_matched) {
      if (Objects.equal(_bind, double.class)) {
        _matched=true;
        CreateMethod _xblockexpression_3 = null;
        {
          cm.ldc(it.getValue());
          cm.invokeStatic(Double.class, "double parseDouble(java/lang/String)");
          cm.invokeStatic(Double.class, "java/lang/Double valueOf(double)");
          _xblockexpression_3 = cm.invokeInterface(toInstance);
        }
        _switchResult = _xblockexpression_3;
      }
    }
    if (!_matched) {
      if (Objects.equal(_bind, float.class)) {
        _matched=true;
        CreateMethod _xblockexpression_4 = null;
        {
          cm.ldc(it.getValue());
          cm.invokeStatic(Float.class, "float parseFloat(java/lang/String)");
          cm.invokeStatic(Float.class, "java/lang/Float valueOf(float)");
          _xblockexpression_4 = cm.invokeInterface(toInstance);
        }
        _switchResult = _xblockexpression_4;
      }
    }
    if (!_matched) {
      if (Objects.equal(_bind, String.class)) {
        _matched=true;
        CreateMethod _xblockexpression_5 = null;
        {
          cm.ldc(it.getValue());
          _xblockexpression_5 = cm.invokeInterface(toInstance);
        }
        _switchResult = _xblockexpression_5;
      }
    }
    if (!_matched) {
      _switchResult = null;
    }
    return _switchResult;
  }
}
