/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.ioc.util;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import cool.taomu.box.asm.CreateClass;
import cool.taomu.box.asm.entity.ClassEntity;
import cool.taomu.box.ioc.util.TaomuResource;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.objectweb.asm.Type;
import org.yaml.snakeyaml.Yaml;

public class TaomuNames {
    private TaomuNames() {
    }

    public static Named named(String name) {
        return Names.named((String)name);
    }

    public static void bindProperties(Binder binder, Map<String, String> properties) {
        Names.bindProperties((Binder)binder, properties);
    }

    public static void bindProperties(Binder binder, Properties properties) {
        Names.bindProperties((Binder)binder, (Properties)properties);
    }

    public static void covertYaml(Binder binder, Map<String, Object> yml) {
        BiConsumer<String, Object> _function = (k, v) -> {
            if (v instanceof Map) {
                TaomuNames.covertChildYaml(binder, k, (Map)v);
            } else {
                new Covert().bind(binder, (String)k, v);
            }
        };
        yml.forEach(_function);
    }

    public static void covertChildYaml(Binder binder, String namespace, Map<String, Object> yml) {
        BiConsumer<String, Object> _function = (k, v) -> {
            String _xifexpression = null;
            boolean _isNotBlank = StringUtils.isNotBlank((CharSequence)k);
            _xifexpression = _isNotBlank ? IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{namespace, k})), (CharSequence)".") : k;
            String ns = _xifexpression;
            if (v instanceof Map) {
                TaomuNames.covertChildYaml(binder, ns, yml);
            } else {
                new Covert().bind(binder, ns, v);
            }
        };
        yml.forEach(_function);
    }

    public static void bindYaml(Binder binder, String path) {
        Map _loadAs;
        Binder binder2 = binder.skipSources(new Class[]{Names.class});
        Yaml yml = new Yaml();
        Map map = _loadAs = (Map)yml.loadAs(TaomuResource.read(path), Map.class);
        TaomuNames.covertYaml(binder2, map);
    }

    public static <T> void bindYaml(Binder binder, final String path, final Class<T> zlass) {
        try {
            Class<?> _loadClass;
            String name = UUID.randomUUID().toString().replace("-", "");
            String moduleName = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"Taomu", name, "BaseModule"})), (CharSequence)"");
            ClassEntity classEntity = new ClassEntity("cool.taomu.box", moduleName);
            classEntity.setSuperclass(Type.getType(zlass).getInternalName());
            CreateClass cc = CreateClass.Class(classEntity);
            cc.constructor(zlass.getConstructors());
            cc.end();
            Class<?> nclass = _loadClass = cc.loadClass(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"cool.taomu.box", moduleName})), (CharSequence)"."));
            AnnotatedBindingBuilder _bind = binder.bind(nclass);
            _bind.toProvider(new Provider<T>(){

                public T get() {
                    Yaml yml = new Yaml();
                    Object t = yml.loadAs(TaomuResource.read(path), zlass);
                    return t;
                }
            });
            binder.bind(zlass).to(nclass).in(Scopes.SINGLETON);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static class Covert {
        protected void _bind(Binder binder, String ns, Integer o) {
            binder.bind(Key.get(Integer.class, (Annotation)Names.named((String)ns))).toInstance((Object)o);
        }

        protected void _bind(Binder binder, String ns, String o) {
            binder.bind(Key.get(String.class, (Annotation)Names.named((String)ns))).toInstance((Object)o);
        }

        protected void _bind(Binder binder, String ns, Double o) {
            binder.bind(Key.get(Double.class, (Annotation)Names.named((String)ns))).toInstance((Object)o);
        }

        protected void _bind(Binder binder, String ns, Float o) {
            binder.bind(Key.get(Float.class, (Annotation)Names.named((String)ns))).toInstance((Object)o);
        }

        protected void _bind(Binder binder, String ns, List<Map<String, Object>> o) {
            binder.bind(Key.get(List.class, (Annotation)Names.named((String)ns))).toInstance(o);
        }

        public void bind(Binder binder, String ns, Object o) {
            if (o instanceof Double) {
                this._bind(binder, ns, (Double)o);
                return;
            }
            if (o instanceof Float) {
                this._bind(binder, ns, (Float)o);
                return;
            }
            if (o instanceof Integer) {
                this._bind(binder, ns, (Integer)o);
                return;
            }
            if (o instanceof List) {
                this._bind(binder, ns, (List)o);
                return;
            }
            if (o instanceof String) {
                this._bind(binder, ns, (String)o);
                return;
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(binder, ns, o).toString());
        }
    }
}

