/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.ioc.entity;

import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@EqualsHashCode
@SuppressWarnings("all")
public class BinderEntity {
  private Class<?> bind = Void.class;
  
  private String named = null;
  
  private Class<?> to = Void.class;
  
  private boolean provider = false;
  
  private Scope in = Scope.None;
  
  private String value = "";
  
  @Pure
  public Class<?> getBind() {
    return this.bind;
  }
  
  public void setBind(final Class<?> bind) {
    this.bind = bind;
  }
  
  @Pure
  public String getNamed() {
    return this.named;
  }
  
  public void setNamed(final String named) {
    this.named = named;
  }
  
  @Pure
  public Class<?> getTo() {
    return this.to;
  }
  
  public void setTo(final Class<?> to) {
    this.to = to;
  }
  
  @Pure
  public boolean isProvider() {
    return this.provider;
  }
  
  public void setProvider(final boolean provider) {
    this.provider = provider;
  }
  
  @Pure
  public Scope getIn() {
    return this.in;
  }
  
  public void setIn(final Scope in) {
    this.in = in;
  }
  
  @Pure
  public String getValue() {
    return this.value;
  }
  
  public void setValue(final String value) {
    this.value = value;
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    BinderEntity other = (BinderEntity) obj;
    if (this.bind == null) {
      if (other.bind != null)
        return false;
    } else if (!this.bind.equals(other.bind))
      return false;
    if (this.named == null) {
      if (other.named != null)
        return false;
    } else if (!this.named.equals(other.named))
      return false;
    if (this.to == null) {
      if (other.to != null)
        return false;
    } else if (!this.to.equals(other.to))
      return false;
    if (other.provider != this.provider)
      return false;
    if (this.in == null) {
      if (other.in != null)
        return false;
    } else if (!this.in.equals(other.in))
      return false;
    if (this.value == null) {
      if (other.value != null)
        return false;
    } else if (!this.value.equals(other.value))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.bind== null) ? 0 : this.bind.hashCode());
    result = prime * result + ((this.named== null) ? 0 : this.named.hashCode());
    result = prime * result + ((this.to== null) ? 0 : this.to.hashCode());
    result = prime * result + (this.provider ? 1231 : 1237);
    result = prime * result + ((this.in== null) ? 0 : this.in.hashCode());
    return prime * result + ((this.value== null) ? 0 : this.value.hashCode());
  }
}
