/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.spi;

import com.google.inject.Guice;
import com.google.inject.Injector;
import cool.taomu.box.ioc.guice.TaomuGuiceModule;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentSkipListMap;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class TaomuServiceLoader<E extends Object> implements ITaomuServiceLoader<E> {
  private static final Logger LOG = LoggerFactory.getLogger(TaomuServiceLoader.class);
  
  private final ConcurrentSkipListMap<String, E> providers = new ConcurrentSkipListMap<String, E>();
  
  private Class<E> zlass;
  
  private ClassLoader loader;
  
  private TaomuGuiceModule tgmodule = new TaomuGuiceModule();
  
  public TaomuServiceLoader(final Class<E> zlass) {
    this(zlass, Thread.currentThread().getContextClassLoader());
  }
  
  public TaomuServiceLoader(final Class<E> zlass, final ClassLoader loader) {
    this.zlass = zlass;
    this.loader = loader;
  }
  
  private synchronized void init() {
    boolean _isEmpty = this.providers.isEmpty();
    if (_isEmpty) {
      ServiceLoader<E> serviceLoader = ServiceLoader.<E>load(this.zlass, this.loader);
      TaomuServiceLoader.LOG.info("spi size:{}", Integer.valueOf(IterableExtensions.size(serviceLoader)));
      final Procedure1<E> _function = (E s) -> {
        com.google.inject.Module module = this.tgmodule.build(s.getClass());
        String _xifexpression = null;
        Alias _annotation = s.getClass().<Alias>getAnnotation(Alias.class);
        boolean _tripleNotEquals = (_annotation != null);
        if (_tripleNotEquals) {
          _xifexpression = s.getClass().<Alias>getAnnotation(Alias.class).value();
        } else {
          _xifexpression = s.getClass().getName();
        }
        String name = _xifexpression;
        TaomuServiceLoader.LOG.info("加载 {}", s.getClass().getName());
        if ((module != null)) {
          TaomuServiceLoader.LOG.info("解析Box");
          final Injector tg = Guice.createInjector(module);
          Object _instance = tg.getInstance(s.getClass());
          this.providers.put(name, ((E) _instance));
        } else {
          this.providers.put(name, s);
        }
      };
      IteratorExtensions.<E>forEach(serviceLoader.iterator(), _function);
    }
  }
  
  @Override
  public E get(final String name) {
    this.init();
    return this.providers.get(name);
  }
  
  @Override
  public Collection<E> getAll() {
    this.init();
    return this.providers.values();
  }
  
  @Override
  public E first() {
    this.init();
    return ((E[])Conversions.unwrapArray(this.providers.values(), Object.class))[0];
  }
  
  @Override
  public E get(final Class<E> zlass) {
    return this.get(zlass.getName());
  }
}
