/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.asm.entity;

import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

@Accessors
@ToString
@SuppressWarnings("all")
public class FieldEntity {
  private int access = Opcodes.ACC_PRIVATE;
  
  private String name;
  
  private String descriptor;
  
  private Object value;
  
  public FieldEntity(final int access, final String name, final String descriptor) {
    this.access = access;
    this.name = name;
    this.descriptor = descriptor;
  }
  
  public FieldEntity(final int access, final String name, final Class<?> zlass) {
    this.access = access;
    this.name = name;
    this.descriptor = Type.getType(zlass).getDescriptor();
  }
  
  @Pure
  public int getAccess() {
    return this.access;
  }
  
  public void setAccess(final int access) {
    this.access = access;
  }
  
  @Pure
  public String getName() {
    return this.name;
  }
  
  public void setName(final String name) {
    this.name = name;
  }
  
  @Pure
  public String getDescriptor() {
    return this.descriptor;
  }
  
  public void setDescriptor(final String descriptor) {
    this.descriptor = descriptor;
  }
  
  @Pure
  public Object getValue() {
    return this.value;
  }
  
  public void setValue(final Object value) {
    this.value = value;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("access", this.access);
    b.add("name", this.name);
    b.add("descriptor", this.descriptor);
    b.add("value", this.value);
    return b.toString();
  }
}
