/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.ioc.util;

import cool.taomu.box.utils.YamlUitls;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class PropertyUtils {
  private static final Logger LOG = LoggerFactory.getLogger(PropertyUtils.class);
  
  public static Properties load(final String prefix) {
    return PropertyUtils.load(prefix, PropertyUtils.class.getClass());
  }
  
  public static Properties load(final String prefix, final Class<?> zlass) {
    try {
      PropertyUtils.LOG.info("加载配置文件:{}", prefix);
      boolean _endsWith = prefix.endsWith(".yml");
      if (_endsWith) {
        Properties p = new YamlUitls().toProperties(prefix);
        return p;
      } else {
        Properties pro = new Properties();
        try (InputStream in = TaomuResource.read(prefix)) {
          pro.load(in);
        }
        return pro;
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
