/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.spi;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import cool.taomu.box.ioc.guice.TaomuGuiceModule;
import cool.taomu.box.spi.Alias;
import cool.taomu.box.spi.ITaomuServiceLoader;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentSkipListMap;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaomuServiceLoader<E>
implements ITaomuServiceLoader<E> {
    private static final Logger LOG = LoggerFactory.getLogger(TaomuServiceLoader.class);
    private final ConcurrentSkipListMap<String, E> providers = new ConcurrentSkipListMap();
    private Class<E> zlass;
    private ClassLoader loader;
    private TaomuGuiceModule tgmodule = new TaomuGuiceModule();

    public TaomuServiceLoader(Class<E> zlass) {
        this(zlass, Thread.currentThread().getContextClassLoader());
    }

    public TaomuServiceLoader(Class<E> zlass, ClassLoader loader) {
        this.zlass = zlass;
        this.loader = loader;
    }

    private synchronized void init() {
        boolean _isEmpty = this.providers.isEmpty();
        if (_isEmpty) {
            ServiceLoader<E> serviceLoader = ServiceLoader.load(this.zlass, this.loader);
            LOG.info("spi size:{}", (Object)IterableExtensions.size(serviceLoader));
            Procedures.Procedure1 _function = s -> {
                Module module = this.tgmodule.build(s.getClass());
                String _xifexpression = null;
                Alias _annotation = s.getClass().getAnnotation(Alias.class);
                boolean _tripleNotEquals = _annotation != null;
                _xifexpression = _tripleNotEquals ? s.getClass().getAnnotation(Alias.class).value() : s.getClass().getName();
                String name = _xifexpression;
                LOG.info("\u52a0\u8f7d {}", (Object)s.getClass().getName());
                if (module != null) {
                    LOG.info("\u89e3\u6790Box");
                    Injector tg = Guice.createInjector((Module[])new Module[]{module});
                    Object _instance = tg.getInstance(s.getClass());
                    this.providers.put(name, _instance);
                } else {
                    this.providers.put(name, s);
                }
            };
            IteratorExtensions.forEach(serviceLoader.iterator(), (Procedures.Procedure1)_function);
        }
    }

    @Override
    public E get(String name) {
        this.init();
        return this.providers.get(name);
    }

    @Override
    public Collection<E> getAll() {
        this.init();
        return this.providers.values();
    }

    @Override
    public E first() {
        this.init();
        return (E)((Object[])Conversions.unwrapArray(this.providers.values(), Object.class))[0];
    }

    @Override
    public E get(Class<E> zlass) {
        return this.get(zlass.getName());
    }
}

