/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.ioc.util;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import cool.taomu.box.asm.CreateClass;
import cool.taomu.box.asm.entity.ClassEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.objectweb.asm.Type;
import org.yaml.snakeyaml.Yaml;

@SuppressWarnings("all")
public class TaomuNames {
  public static class Covert {
    protected void _bind(final Binder binder, final String ns, final Integer o) {
      binder.<Integer>bind(Key.<Integer>get(Integer.class, Names.named(ns))).toInstance(o);
    }
    
    protected void _bind(final Binder binder, final String ns, final String o) {
      binder.<String>bind(Key.<String>get(String.class, Names.named(ns))).toInstance(o);
    }
    
    protected void _bind(final Binder binder, final String ns, final Double o) {
      binder.<Double>bind(Key.<Double>get(Double.class, Names.named(ns))).toInstance(o);
    }
    
    protected void _bind(final Binder binder, final String ns, final Float o) {
      binder.<Float>bind(Key.<Float>get(Float.class, Names.named(ns))).toInstance(o);
    }
    
    protected void _bind(final Binder binder, final String ns, final List<Map<String, Object>> o) {
      binder.<List>bind(Key.<List>get(List.class, Names.named(ns))).toInstance(o);
    }
    
    public void bind(final Binder binder, final String ns, final Object o) {
      if (o instanceof Double) {
        _bind(binder, ns, (Double)o);
        return;
      } else if (o instanceof Float) {
        _bind(binder, ns, (Float)o);
        return;
      } else if (o instanceof Integer) {
        _bind(binder, ns, (Integer)o);
        return;
      } else if (o instanceof List) {
        _bind(binder, ns, (List<Map<String, Object>>)o);
        return;
      } else if (o instanceof String) {
        _bind(binder, ns, (String)o);
        return;
      } else {
        throw new IllegalArgumentException("Unhandled parameter types: " +
          Arrays.<Object>asList(binder, ns, o).toString());
      }
    }
  }
  
  private TaomuNames() {
  }
  
  public static Named named(final String name) {
    return Names.named(name);
  }
  
  public static void bindProperties(final Binder binder, final Map<String, String> properties) {
    Names.bindProperties(binder, properties);
  }
  
  public static void bindProperties(final Binder binder, final Properties properties) {
    Names.bindProperties(binder, properties);
  }
  
  public static void covertYaml(final Binder binder, final Map<String, Object> yml) {
    final BiConsumer<String, Object> _function = (String k, Object v) -> {
      if ((v instanceof Map)) {
        TaomuNames.covertChildYaml(binder, k, ((Map<String, Object>)v));
      } else {
        new TaomuNames.Covert().bind(binder, k, v);
      }
    };
    yml.forEach(_function);
  }
  
  public static void covertChildYaml(final Binder binder, final String namespace, final Map<String, Object> yml) {
    final BiConsumer<String, Object> _function = (String k, Object v) -> {
      String _xifexpression = null;
      boolean _isNotBlank = StringUtils.isNotBlank(k);
      if (_isNotBlank) {
        _xifexpression = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(namespace, k)), ".");
      } else {
        _xifexpression = k;
      }
      String ns = _xifexpression;
      if ((v instanceof Map)) {
        TaomuNames.covertChildYaml(binder, ns, yml);
      } else {
        new TaomuNames.Covert().bind(binder, ns, v);
      }
    };
    yml.forEach(_function);
  }
  
  public static void bindYaml(final Binder binder, final String path) {
    Binder binder2 = binder.skipSources(Names.class);
    Yaml yml = new Yaml();
    Map _loadAs = yml.<Map>loadAs(TaomuResource.read(path), Map.class);
    Map<String, Object> map = ((Map<String, Object>) _loadAs);
    TaomuNames.covertYaml(binder2, map);
  }
  
  public static <T extends Object> void bindYaml(final Binder binder, final String path, final Class<T> zlass) {
    try {
      String name = UUID.randomUUID().toString().replace("-", "");
      String moduleName = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("Taomu", name, "BaseModule")), "");
      ClassEntity classEntity = new ClassEntity("cool.taomu.box", moduleName);
      classEntity.setSuperclass(Type.getType(zlass).getInternalName());
      CreateClass cc = CreateClass.Class(classEntity);
      cc.constructor(zlass.getConstructors());
      cc.end();
      Class<?> _loadClass = cc.loadClass(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("cool.taomu.box", moduleName)), "."));
      Class<T> nclass = ((Class<T>) _loadClass);
      AnnotatedBindingBuilder<T> _bind = binder.<T>bind(nclass);
      _bind.toProvider(new Provider<T>() {
        @Override
        public T get() {
          Yaml yml = new Yaml();
          T t = yml.<T>loadAs(TaomuResource.read(path), zlass);
          return t;
        }
      });
      binder.<T>bind(zlass).to(nclass).in(Scopes.SINGLETON);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
