package cool.taomu.box.asm.aspect2;

import java.lang.reflect.Method;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@SuppressWarnings("all")
public class AspectHandle {
  private Object instance;
  
  private Object[] arguments;
  
  private Method method;
  
  public String getMethodName() {
    return this.method.getName();
  }
  
  public Class<?> getReturnType() {
    return this.method.getReturnType();
  }
  
  public Object invoke() {
    try {
      return this.method.invoke(this.instance, this.arguments);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Pure
  public Object getInstance() {
    return this.instance;
  }
  
  public void setInstance(final Object instance) {
    this.instance = instance;
  }
  
  @Pure
  public Object[] getArguments() {
    return this.arguments;
  }
  
  public void setArguments(final Object[] arguments) {
    this.arguments = arguments;
  }
  
  @Pure
  public Method getMethod() {
    return this.method;
  }
  
  public void setMethod(final Method method) {
    this.method = method;
  }
}
