package cool.taomu.box.asm.aspect2;

import com.google.common.base.Objects;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

@SuppressWarnings("all")
public class BytecodeUtils {
  /**
   * 构建返回值
   */
  public static void buildReturnValue(final Method m, final FigGeneratorAdapter ga) {
    Class<?> _returnType = m.getReturnType();
    boolean _matched = false;
    if (Objects.equal(_returnType, int.class)) {
      _matched=true;
      ga.checkCast(Integer.class);
      ga.invokeVirtual(Integer.class, "int intValue()");
    }
    if (!_matched) {
      if (Objects.equal(_returnType, long.class)) {
        _matched=true;
        ga.checkCast(Long.class);
        ga.invokeVirtual(Long.class, "long longValue()");
      }
    }
    if (!_matched) {
      if (Objects.equal(_returnType, double.class)) {
        _matched=true;
        ga.checkCast(Double.class);
        ga.invokeVirtual(Double.class, "double doubleValue()");
      }
    }
    if (!_matched) {
      if (Objects.equal(_returnType, float.class)) {
        _matched=true;
        ga.checkCast(Float.class);
        ga.invokeVirtual(Float.class, "float floatValue()");
      }
    }
    if (!_matched) {
      if (Objects.equal(_returnType, boolean.class)) {
        _matched=true;
        ga.checkCast(Boolean.class);
        ga.invokeVirtual(Boolean.class, "boolean booleanValue()");
      }
    }
    if (!_matched) {
      if (Objects.equal(_returnType, short.class)) {
        _matched=true;
        ga.checkCast(Short.class);
        ga.invokeVirtual(Short.class, "short shortValue()");
      }
    }
    if (!_matched) {
      if (Objects.equal(_returnType, char.class)) {
        _matched=true;
        ga.checkCast(Character.class);
        ga.invokeVirtual(Character.class, "char charValue()");
      }
    }
    if (!_matched) {
      if (Objects.equal(_returnType, byte.class)) {
        _matched=true;
        ga.checkCast(Byte.class);
        ga.invokeVirtual(Byte.class, "byte byteValue()");
      }
    }
    if (!_matched) {
      if (Objects.equal(_returnType, void.class)) {
        _matched=true;
      }
    }
    if (!_matched) {
      ga.checkCast(m.getReturnType());
    }
  }
  
  /**
   * 构建AspectHandle的参数
   */
  public static void buildArguments(final org.objectweb.asm.commons.Method method, final FigGeneratorAdapter ga) {
    int _size = ((List<Type>)Conversions.doWrapArray(method.getArgumentTypes())).size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      for (int index = 0; (index < ((List<Type>)Conversions.doWrapArray(method.getArgumentTypes())).size()); index++) {
        {
          ga.dup();
          ga.push(index);
          String _descriptor = (method.getArgumentTypes()[index]).getDescriptor();
          if (_descriptor != null) {
            switch (_descriptor) {
              case "Z":
                ga.loadArg(index);
                ga.invokeStatic(Boolean.class, "Boolean valueOf(boolean)");
                break;
              case "C":
                ga.loadArg(index);
                ga.invokeStatic(Character.class, "Character valueOf(char)");
                break;
              case "B":
                ga.loadArg(index);
                ga.invokeStatic(Byte.class, "Byte valueOf(byte)");
                break;
              case "S":
                ga.loadArg(index);
                ga.invokeStatic(Short.class, "Short valueOf(short)");
                break;
              case "I":
                ga.loadArg(index);
                ga.invokeStatic(Integer.class, "Integer valueOf(int)");
                break;
              case "F":
                ga.loadArg(index);
                ga.invokeStatic(Float.class, "Float valueOf(float)");
                break;
              case "J":
                ga.loadArg(index);
                ga.invokeStatic(Float.class, "Long valueOf(long)");
                break;
              case "D":
                ga.loadArg(index);
                ga.invokeStatic(Float.class, "Double valueOf(double)");
                break;
              default:
                ga.visitVarInsn(Opcodes.ALOAD, (index + 1));
                break;
            }
          } else {
            ga.visitVarInsn(Opcodes.ALOAD, (index + 1));
          }
          ga.visitInsn(Opcodes.AASTORE);
        }
      }
    } else {
      ga.visitInsn(Opcodes.ACONST_NULL);
    }
  }
}
