/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.asm.aspect2;

import com.google.common.base.Objects;
import cool.taomu.box.asm.aspect2.FigGeneratorAdapter;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.objectweb.asm.commons.Method;

public class BytecodeUtils {
    public static void buildReturnValue(java.lang.reflect.Method m, FigGeneratorAdapter ga) {
        Class<?> _returnType = m.getReturnType();
        boolean _matched = false;
        if (Objects.equal(_returnType, Integer.TYPE)) {
            _matched = true;
            ga.checkCast(Integer.class);
            ga.invokeVirtual(Integer.class, "int intValue()");
        }
        if (!_matched && Objects.equal(_returnType, Long.TYPE)) {
            _matched = true;
            ga.checkCast(Long.class);
            ga.invokeVirtual(Long.class, "long longValue()");
        }
        if (!_matched && Objects.equal(_returnType, Double.TYPE)) {
            _matched = true;
            ga.checkCast(Double.class);
            ga.invokeVirtual(Double.class, "double doubleValue()");
        }
        if (!_matched && Objects.equal(_returnType, Float.TYPE)) {
            _matched = true;
            ga.checkCast(Float.class);
            ga.invokeVirtual(Float.class, "float floatValue()");
        }
        if (!_matched && Objects.equal(_returnType, Boolean.TYPE)) {
            _matched = true;
            ga.checkCast(Boolean.class);
            ga.invokeVirtual(Boolean.class, "boolean booleanValue()");
        }
        if (!_matched && Objects.equal(_returnType, Short.TYPE)) {
            _matched = true;
            ga.checkCast(Short.class);
            ga.invokeVirtual(Short.class, "short shortValue()");
        }
        if (!_matched && Objects.equal(_returnType, Character.TYPE)) {
            _matched = true;
            ga.checkCast(Character.class);
            ga.invokeVirtual(Character.class, "char charValue()");
        }
        if (!_matched && Objects.equal(_returnType, Byte.TYPE)) {
            _matched = true;
            ga.checkCast(Byte.class);
            ga.invokeVirtual(Byte.class, "byte byteValue()");
        }
        if (!_matched && Objects.equal(_returnType, Void.TYPE)) {
            _matched = true;
        }
        if (!_matched) {
            ga.checkCast(m.getReturnType());
        }
    }

    public static void buildArguments(Method method, FigGeneratorAdapter ga) {
        boolean _greaterThan;
        int _size = ((List)Conversions.doWrapArray((Object)method.getArgumentTypes())).size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            for (int index = 0; index < ((List)Conversions.doWrapArray((Object)method.getArgumentTypes())).size(); ++index) {
                ga.dup();
                ga.push(index);
                String _descriptor = method.getArgumentTypes()[index].getDescriptor();
                if (_descriptor != null) {
                    switch (_descriptor) {
                        case "Z": {
                            ga.loadArg(index);
                            ga.invokeStatic(Boolean.class, "Boolean valueOf(boolean)");
                            break;
                        }
                        case "C": {
                            ga.loadArg(index);
                            ga.invokeStatic(Character.class, "Character valueOf(char)");
                            break;
                        }
                        case "B": {
                            ga.loadArg(index);
                            ga.invokeStatic(Byte.class, "Byte valueOf(byte)");
                            break;
                        }
                        case "S": {
                            ga.loadArg(index);
                            ga.invokeStatic(Short.class, "Short valueOf(short)");
                            break;
                        }
                        case "I": {
                            ga.loadArg(index);
                            ga.invokeStatic(Integer.class, "Integer valueOf(int)");
                            break;
                        }
                        case "F": {
                            ga.loadArg(index);
                            ga.invokeStatic(Float.class, "Float valueOf(float)");
                            break;
                        }
                        case "J": {
                            ga.loadArg(index);
                            ga.invokeStatic(Float.class, "Long valueOf(long)");
                            break;
                        }
                        case "D": {
                            ga.loadArg(index);
                            ga.invokeStatic(Float.class, "Double valueOf(double)");
                            break;
                        }
                        default: {
                            ga.visitVarInsn(25, index + 1);
                            break;
                        }
                    }
                } else {
                    ga.visitVarInsn(25, index + 1);
                }
                ga.visitInsn(83);
            }
        } else {
            ga.visitInsn(1);
        }
    }
}

