/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.asm.aspect2;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class FigGeneratorAdapter {
    private Map<String, Variable> fields = new HashMap<String, Variable>();
    private Map<String, Label> labels = new HashMap<String, Label>();
    private GeneratorAdapter ga = null;
    private MethodVisitor mv = null;

    public FigGeneratorAdapter(int access, Method method, String signature, Type[] exceptions, ClassVisitor classVisitor) {
        GeneratorAdapter _generatorAdapter;
        this.mv = classVisitor.visitMethod(access, method.getName(), method.getDescriptor(), signature, null);
        this.ga = _generatorAdapter = new GeneratorAdapter(access, method, this.mv);
    }

    public Label newLables(String key) {
        Label _label = new Label();
        return this.labels.put(key, _label);
    }

    public void visitTryCatchBlock(String start, String end, String catchBlock) {
        this.visitTryCatchBlock(start, end, catchBlock, null);
    }

    public void visitTryCatchBlock(String start, String end, String catchBlock, Class<?> zlass) {
        Label l0 = this.labels.get(start);
        Label l1 = this.labels.get(end);
        Label cb = this.labels.get(catchBlock);
        if (zlass == null) {
            this.mv.visitTryCatchBlock(l0, l1, cb, null);
        } else {
            this.mv.visitTryCatchBlock(l0, l1, cb, Type.getType(zlass).getInternalName());
        }
    }

    public void aconst_null() {
        this.ga.visitInsn(1);
    }

    public void mark(String key) {
        this.ga.mark(this.labels.get(key));
    }

    public void goTo(String key) {
        this.ga.goTo(this.labels.get(key));
    }

    public Variable newInstance(String name, Class<?> type) {
        Variable _xblockexpression = null;
        Type classType = Type.getType(type);
        this.ga.newInstance(classType);
        this.ga.dup();
        this.ga.invokeConstructor(classType, Method.getMethod((String)"void <init>()"));
        int l1 = this.ga.newLocal(classType);
        this.ga.storeLocal(l1, classType);
        Variable _variable = new Variable(l1, classType);
        _xblockexpression = this.fields.put(name, _variable);
        return _xblockexpression;
    }

    public Variable newArray(int size, Class<?> type, FigAsm asm) {
        return this.newArray(null, size, type, asm);
    }

    public Variable newArray(String name, int size, Class<?> type, FigAsm asm) {
        Variable _xblockexpression = null;
        Type classType = Type.getType(type);
        this.ga.push(size);
        this.ga.newArray(classType);
        asm.code(this);
        int l1 = this.ga.newLocal(classType);
        Variable _xifexpression = null;
        if (name != null) {
            Variable _xblockexpression_1 = null;
            this.ga.storeLocal(l1, classType);
            Variable _variable = new Variable(l1, classType);
            _xifexpression = _xblockexpression_1 = this.fields.put(name, _variable);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public Variable store(String name) {
        return this.store(name, Object.class);
    }

    public Variable store(String name, Class<?> type) {
        Variable _xblockexpression = null;
        Type classType = Type.getType(type);
        int _newLocal = this.ga.newLocal(classType);
        Variable _variable = new Variable(_newLocal, classType);
        Variable v = this.fields.getOrDefault(name, _variable);
        this.ga.storeLocal(v.index, v.type);
        _xblockexpression = this.fields.put(name, v);
        return _xblockexpression;
    }

    public void ifnull(String key) {
        this.ga.ifNull(this.labels.get(key));
    }

    public void ifnonnull(String key) {
        this.ga.ifNonNull(this.labels.get(key));
    }

    public void ifacmpeq(String key) {
        this.ga.ifCmp(Type.getType(Object.class), 165, this.labels.get(key));
    }

    public void loadLocal(String name) {
        Variable v = this.fields.get(name);
        this.ga.loadLocal(v.index, v.type);
    }

    public void athrow() {
        this.ga.throwException();
    }

    public void invokeVirtual(Class<?> type, String method, boolean defaultPackage) {
        this.ga.invokeVirtual(Type.getType(type), Method.getMethod((String)method, (boolean)defaultPackage));
    }

    public void invokeVirtual(Class<?> type, String method) {
        this.invokeVirtual(type, method, false);
    }

    public void invokeVirtual(Class<?> type, java.lang.reflect.Method method) {
        this.ga.invokeVirtual(Type.getType(type), Method.getMethod((java.lang.reflect.Method)method));
    }

    public void invokeStatic(Class<?> type, String method, boolean defaultPackage) {
        this.ga.invokeStatic(Type.getType(type), Method.getMethod((String)method, (boolean)defaultPackage));
    }

    public void invokeStatic(Class<?> type, String method) {
        this.invokeStatic(type, method, false);
    }

    public void dup() {
        this.ga.dup();
    }

    public void push(Class<?> zlass) {
        this.ga.push(Type.getType(zlass));
    }

    public void push(Type type) {
        this.ga.push(type);
    }

    public void push(String value) {
        this.ga.push(value);
    }

    public void push(int value) {
        this.ga.push(value);
    }

    public void returnValue() {
        this.ga.returnValue();
    }

    public void endMethod() {
        this.ga.endMethod();
    }

    public void checkCast(Class<?> type) {
        this.ga.checkCast(Type.getType(type));
    }

    public void visitInsn(int i) {
        this.ga.visitInsn(i);
    }

    public void visitVarInsn(int opcode, int v) {
        this.ga.visitVarInsn(opcode, v);
    }

    public void loadArg(int arg) {
        this.ga.loadArg(arg);
    }

    @Accessors
    public static class Variable {
        private int index;
        private Type type;

        public Variable(int index, Type type) {
            this.index = index;
            this.type = type;
        }

        @Pure
        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        @Pure
        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }
    }

    public static interface FigAsm {
        public void code(FigGeneratorAdapter var1);
    }
}

