/**
 * Copyright (c) 2021-2022 murenchao
 * fig is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.asm.aspect2;

import cool.taomu.box.asm.aspect2.annotation.Around;
import cool.taomu.box.asm.aspect2.annotation.Aspect;
import cool.taomu.box.asm.aspect2.classloader.FigClassLoaderManage;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class AspectUtils {
  private final HashMap<String, Class<?>> aspectClassMap = new HashMap<String, Class<?>>();
  
  private static final AspectUtils instance = new AspectUtils();
  
  private static final String CLASS_NAME_PREFIX = "FigAspect_";
  
  private final boolean isDebug = false;
  
  private AspectUtils() {
  }
  
  public static synchronized AspectUtils getInstance() {
    return AspectUtils.instance;
  }
  
  public AspectUtils build(final Class<?> aspectClass) {
    final Aspect aspect = aspectClass.<Aspect>getAnnotation(Aspect.class);
    if ((aspect != null)) {
      Method[] _declaredMethods = aspectClass.getDeclaredMethods();
      for (final Method method : _declaredMethods) {
        {
          final Around around = method.<Around>getAnnotation(Around.class);
          if ((around != null)) {
            final Consumer<Class<?>> _function = (Class<?> v) -> {
              this.aspectClassMap.put(v.getName(), this.aspect(v, aspectClass, method.getName()));
            };
            ((List<Class<?>>)Conversions.doWrapArray(around.value())).forEach(_function);
          }
        }
      }
    }
    return this;
  }
  
  public Class<?> getClass(final Class<?> zlass) {
    return this.getClass(zlass.getName());
  }
  
  public Class<?> getClass(final String name) {
    return this.aspectClassMap.get(name);
  }
  
  public Class<?> aspect(final Class<?> dest, final Class<?> aspect, final String methodName) {
    try {
      GenerateUtils g = new GenerateUtils();
      String _replace = UUID.randomUUID().toString().replace("-", "");
      final String uuid = (AspectUtils.CLASS_NAME_PREFIX + _replace);
      final GenerateUtils.Asm _function = (ClassVisitor v, Class<?> s, Class<?>[] i) -> {
        v.visitField((Opcodes.ACC_PRIVATE + Opcodes.ACC_STATIC), "LOG", Type.getType(Logger.class).getDescriptor(), null, 
          null).visitEnd();
        org.objectweb.asm.commons.Method _method = org.objectweb.asm.commons.Method.getMethod("void <clinit>()");
        final GeneratorAdapter gar = new GeneratorAdapter(Opcodes.ACC_STATIC, _method, null, null, v);
        gar.push(Type.getObjectType(uuid));
        gar.invokeStatic(Type.getType(LoggerFactory.class), 
          org.objectweb.asm.commons.Method.getMethod("org/slf4j/Logger getLogger(java/lang/Class)", true));
        gar.putStatic(Type.getObjectType(uuid), "LOG", Type.getType(Logger.class));
        gar.returnValue();
        gar.endMethod();
        final Consumer<Method> _function_1 = (Method m) -> {
          try {
            final org.objectweb.asm.commons.Method method = org.objectweb.asm.commons.Method.getMethod(m);
            final FigGeneratorAdapter ga = new FigGeneratorAdapter(Opcodes.ACC_PUBLIC, method, null, null, v);
            ga.newInstance("aspect", aspect);
            ga.newInstance("aspectHandle", AspectHandle.class);
            ga.loadLocal("aspectHandle");
            final FigGeneratorAdapter.FigAsm _function_2 = (FigGeneratorAdapter it) -> {
              BytecodeUtils.buildArguments(method, it);
            };
            ga.newArray(((List<Type>)Conversions.doWrapArray(method.getArgumentTypes())).size(), Object.class, _function_2);
            ga.invokeVirtual(AspectHandle.class, "void setArguments(Object[])");
            ga.loadLocal("aspectHandle");
            ga.push(dest);
            ga.push(method.getName());
            final FigGeneratorAdapter.FigAsm _function_3 = (FigGeneratorAdapter it) -> {
              int _size = ((List<Type>)Conversions.doWrapArray(method.getArgumentTypes())).size();
              boolean _greaterThan = (_size > 0);
              if (_greaterThan) {
                for (int index = 0; (index < ((List<Type>)Conversions.doWrapArray(method.getArgumentTypes())).size()); index++) {
                  {
                    it.dup();
                    it.push(index);
                    it.push(method.getArgumentTypes()[index]);
                    it.visitInsn(Opcodes.AASTORE);
                  }
                }
              } else {
                it.visitInsn(Opcodes.ACONST_NULL);
              }
            };
            ga.newArray(((List<Type>)Conversions.doWrapArray(method.getArgumentTypes())).size(), Class.class, _function_3);
            ga.invokeVirtual(Class.class, 
              "java/lang/reflect/Method getDeclaredMethod (java/lang/String,java/lang/Class[])", true);
            ga.invokeVirtual(AspectHandle.class, "void setMethod(java/lang/reflect/Method)", true);
            ga.newInstance("dest", dest);
            ga.loadLocal("aspectHandle");
            ga.loadLocal("dest");
            ga.invokeVirtual(AspectHandle.class, "void setInstance(Object)");
            ga.loadLocal("aspect");
            ga.loadLocal("aspectHandle");
            Method aspectMethodName = aspect.getDeclaredMethod(methodName, AspectHandle.class);
            ga.invokeVirtual(aspect, aspectMethodName);
            BytecodeUtils.buildReturnValue(m, ga);
            ga.returnValue();
            ga.endMethod();
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        };
        ((List<Method>)Conversions.doWrapArray(dest.getDeclaredMethods())).forEach(_function_1);
      };
      byte[] newClassBytes = g.gen(uuid, dest, null, _function, this.isDebug);
      if (this.isDebug) {
        try (FileOutputStream fos = new Function0<FileOutputStream>() {
          @Override
          public FileOutputStream apply() {
            try {
              return new FileOutputStream("./a.class");
            } catch (Throwable _e) {
              throw Exceptions.sneakyThrow(_e);
            }
          }
        }.apply()) {
          fos.write(newClassBytes);
        }
      }
      FigClassLoaderManage fig = new FigClassLoaderManage();
      fig.register(uuid, newClassBytes);
      return fig.getClassLoader(uuid);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
