package cool.taomu.box.asm.aspect2.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Accessors
@SuppressWarnings("all")
public class FigClassLoader extends URLClassLoader {
  private static final Logger LOG = LoggerFactory.getLogger(FigClassLoader.class);
  
  private Class<?> zlass = null;
  
  private String zlassName = "";
  
  public FigClassLoader() {
    super(new URL[] {});
  }
  
  public Class<?> register(final String name, final byte[] bytes) {
    Class<?> _xblockexpression = null;
    {
      this.zlassName = name;
      _xblockexpression = this.zlass = super.defineClass(name, bytes, 0, bytes.length);
    }
    return _xblockexpression;
  }
  
  public Class<?> register(final String name, final Class<?> zlass) {
    Class<?> _xblockexpression = null;
    {
      this.zlassName = zlass.getName();
      _xblockexpression = this.zlass = zlass;
    }
    return _xblockexpression;
  }
  
  public Class<?> register(final Class<?> zlass) {
    Class<?> _xblockexpression = null;
    {
      this.zlassName = zlass.getName();
      _xblockexpression = this.zlass = zlass;
    }
    return _xblockexpression;
  }
  
  public void loadJar(final String jarPath) {
    try {
      StringBuffer sb = new StringBuffer("jar:file:/");
      sb.append(jarPath);
      sb.append("!/");
      String _string = sb.toString();
      URL _uRL = new URL(_string);
      super.addURL(_uRL);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        FigClassLoader.LOG.error("Failed to cache plugin JAR file", e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  @Override
  public Class<?> findClass(final String name) {
    try {
      FigClassLoaderManage fig = new FigClassLoaderManage();
      FigClassLoader zlass = fig.get(name);
      if ((zlass != null)) {
        return zlass.loadClass(name);
      } else {
        return System.class.getClassLoader().loadClass(name);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Pure
  public Class<?> getZlass() {
    return this.zlass;
  }
  
  public void setZlass(final Class<?> zlass) {
    this.zlass = zlass;
  }
  
  @Pure
  public String getZlassName() {
    return this.zlassName;
  }
  
  public void setZlassName(final String zlassName) {
    this.zlassName = zlassName;
  }
}
