package cool.taomu.box.asm.aspect2.classloader;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentSkipListMap;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class FigClassLoaderManage {
  @Documented
  @Retention(RetentionPolicy.RUNTIME)
  @Target(ElementType.FIELD)
  public @interface Autowired {
    public Class<?> value() default void.class;
    public String name() default "";
  }
  
  private static final ConcurrentSkipListMap<String, FigClassLoader> classes = new ConcurrentSkipListMap<String, FigClassLoader>();
  
  public void register(final String name, final byte[] bytes) {
    final FigClassLoader classLoader = new FigClassLoader();
    classLoader.register(name, bytes);
    FigClassLoaderManage.classes.put(name, classLoader);
  }
  
  public void register(final Class<?> zlass, final byte[] bytes) {
    final FigClassLoader classLoader = new FigClassLoader();
    classLoader.register(zlass.getName(), bytes);
    FigClassLoaderManage.classes.put(zlass.getName(), classLoader);
  }
  
  public void register(final String name, final Class<?> zlass) {
    final FigClassLoader classLoader = new FigClassLoader();
    classLoader.register(name, zlass);
    FigClassLoaderManage.classes.put(name, classLoader);
  }
  
  public Class<?> getClassLoader(final String name) {
    try {
      FigClassLoader classLoader = FigClassLoaderManage.classes.get(name);
      if ((classLoader == null)) {
        Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(name);
        return cl;
      }
      return classLoader.loadClass(name);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public FigClassLoader register(final Class<?> zlass) {
    FigClassLoader _xblockexpression = null;
    {
      final FigClassLoader classLoader = new FigClassLoader();
      classLoader.register(zlass);
      _xblockexpression = FigClassLoaderManage.classes.put(zlass.getName(), classLoader);
    }
    return _xblockexpression;
  }
  
  public FigClassLoader get(final String key) {
    boolean _containsKey = FigClassLoaderManage.classes.containsKey(key);
    if (_containsKey) {
      return FigClassLoaderManage.classes.get(key);
    }
    return null;
  }
  
  public Object getBean(final String className) {
    try {
      boolean _containsKey = FigClassLoaderManage.classes.containsKey(className);
      if (_containsKey) {
        Class<?> zlass2 = this.getClassLoader(className);
        return this.getBean(zlass2);
      } else {
        Class<?> zlass = Thread.currentThread().getContextClassLoader().loadClass(className);
        return this.getBean(zlass);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public Object getBean(final Class<?> key) {
    boolean _containsKey = FigClassLoaderManage.classes.containsKey(key.getName());
    boolean _not = (!_containsKey);
    if (_not) {
      this.register(key);
    }
    Class<?> zlass = this.getClassLoader(key.getName());
    Object instance = ReflectUtils.newInstance(zlass, null);
    Field[] fields = ReflectUtils.getReflectFields(zlass);
    for (final Field field : fields) {
      {
        FigClassLoaderManage.Autowired autowired = field.<FigClassLoaderManage.Autowired>getAnnotation(FigClassLoaderManage.Autowired.class);
        if ((autowired != null)) {
          boolean _equals = autowired.value().equals(void.class);
          boolean _not_1 = (!_equals);
          if (_not_1) {
            Object fieldInstance = this.getBean(autowired.value());
            ReflectUtils.setReflectFields(zlass, field.getName(), instance, fieldInstance);
          } else {
            boolean _equals_1 = autowired.name().equals("");
            boolean _not_2 = (!_equals_1);
            if (_not_2) {
              Object fieldInstance_1 = this.getBean(autowired.name());
              ReflectUtils.setReflectFields(zlass, field.getName(), instance, fieldInstance_1);
            } else {
              boolean _isInterface = field.getType().isInterface();
              boolean _not_3 = (!_isInterface);
              if (_not_3) {
                Object fieldInstance_2 = this.getBean(field.getType());
                ReflectUtils.setReflectFields(zlass, field.getName(), instance, fieldInstance_2);
              }
            }
          }
        }
      }
    }
    return instance;
  }
}
