/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.guice.util;

import com.google.common.collect.ArrayListMultimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.yaml.snakeyaml.Yaml;

@SuppressWarnings("all")
public class PropertyUtils {
  public static Properties load(final String prefix) {
    return PropertyUtils.load(prefix, PropertyUtils.class.getClass());
  }
  
  public static Properties load(final String prefix, final Class<?> zlass) {
    try {
      boolean _endsWith = prefix.endsWith(".yml");
      if (_endsWith) {
        File fpath = PropertyUtils.ymlToProperty(prefix);
        Properties pro = new Properties();
        try (FileInputStream in = new Function0<FileInputStream>() {
          @Override
          public FileInputStream apply() {
            try {
              return new FileInputStream(fpath);
            } catch (Throwable _e) {
              throw Exceptions.sneakyThrow(_e);
            }
          }
        }.apply()) {
          pro.load(in);
          fpath.delete();
        }
        return pro;
      } else {
        Properties pro_1 = new Properties();
        try (InputStream in = TaomuResource.read(prefix)) {
          pro_1.load(in);
        }
        return pro_1;
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static File ymlToProperty(final String prefix) {
    try {
      final ArrayListMultimap<String, Object> m = ArrayListMultimap.<String, Object>create();
      Yaml yml = new Yaml();
      Map results = yml.<Map>loadAs(TaomuResource.read(prefix), Map.class);
      final BiConsumer<String, Object> _function = (String k, Object v) -> {
        if ((v instanceof Map)) {
          PropertyUtils.toProperty(m, k, ((Map<String, Object>)v));
        } else {
          if ((v instanceof List)) {
            final Consumer<Map<String, Object>> _function_1 = (Map<String, Object> it) -> {
              PropertyUtils.toProperty(m, k, it);
            };
            ((List)v).forEach(_function_1);
          } else {
            m.put(k, v);
          }
        }
      };
      results.forEach(_function);
      final File pfile = File.createTempFile(UUID.randomUUID().toString(), ".properties");
      final BiConsumer<String, Object> _function_1 = (String k, Object v) -> {
        try {
          String _join = IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(k, v)), "=");
          String _plus = (_join + "\n");
          FileUtils.writeStringToFile(pfile, _plus, "UTF-8", true);
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      m.forEach(_function_1);
      return pfile;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private static void toProperty(final ArrayListMultimap<String, Object> convert, final String key, final Map<String, Object> map) {
    final BiConsumer<String, Object> _function = (String k, Object v) -> {
      String _xifexpression = null;
      boolean _isNotBlank = StringUtils.isNotBlank(key);
      if (_isNotBlank) {
        _xifexpression = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(key, k)), ".");
      } else {
        _xifexpression = k;
      }
      final String namespace = _xifexpression;
      if ((v instanceof Map)) {
        PropertyUtils.toProperty(convert, namespace, ((Map<String, Object>)v));
      } else {
        if ((v instanceof List)) {
          final Consumer<Map<String, Object>> _function_1 = (Map<String, Object> it) -> {
            PropertyUtils.toProperty(convert, namespace, it);
          };
          ((List)v).forEach(_function_1);
        } else {
          convert.put(namespace, v);
        }
      }
    };
    map.forEach(_function);
  }
}
