/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.guice.entity;

import com.google.inject.matcher.Matcher;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@SuppressWarnings("all")
public class InterceptorEntity {
  private Matcher<? super Class<?>> classMatcher;
  
  private Matcher<? super Method> methodMatcher;
  
  private MethodInterceptor[] interceptors;
  
  public InterceptorEntity() {
  }
  
  public InterceptorEntity(final Matcher<? super Class<?>> classMatcher, final Matcher<? super Method> methodMatcher, final MethodInterceptor... interceptors) {
    this.classMatcher = classMatcher;
    this.methodMatcher = methodMatcher;
    this.interceptors = interceptors;
  }
  
  @Pure
  public Matcher<? super Class<?>> getClassMatcher() {
    return this.classMatcher;
  }
  
  public void setClassMatcher(final Matcher<? super Class<?>> classMatcher) {
    this.classMatcher = classMatcher;
  }
  
  @Pure
  public Matcher<? super Method> getMethodMatcher() {
    return this.methodMatcher;
  }
  
  public void setMethodMatcher(final Matcher<? super Method> methodMatcher) {
    this.methodMatcher = methodMatcher;
  }
  
  @Pure
  public MethodInterceptor[] getInterceptors() {
    return this.interceptors;
  }
  
  public void setInterceptors(final MethodInterceptor[] interceptors) {
    this.interceptors = interceptors;
  }
}
