/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.ioc.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class TaomuResource {
  public static InputStream read(final String path) {
    try {
      ClassLoader cl = Thread.currentThread().getContextClassLoader();
      if ((cl == null)) {
        cl = ClassLoader.getSystemClassLoader();
      }
      if ((cl != null)) {
        InputStream is = cl.getResourceAsStream(path);
        if ((is == null)) {
          is = ClassLoader.getSystemResourceAsStream(path);
        }
        if ((is == null)) {
          File _file = new File(("./config/" + path));
          FileInputStream _fileInputStream = new FileInputStream(_file);
          is = _fileInputStream;
        }
        return is;
      }
      return null;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
