/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.asm;

import cool.taomu.box.asm.CreateMethod;
import cool.taomu.box.asm.entity.ClassEntity;
import cool.taomu.box.asm.entity.FieldEntity;
import cool.taomu.box.asm.entity.MethodEntity;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.TraceClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateClass
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CreateClass.class);
    private ClassWriter cwriter;
    private ClassVisitor tcvisitor;
    private GeneratorAdapter ga;
    private ClassEntity classEntity;
    private byte[] bytecode;

    public CreateClass(ClassEntity classEntity, int version, int access) {
        this(classEntity, version, access, false);
    }

    public CreateClass(ClassEntity classEntity, int version, int access, boolean isDebug) {
        ClassWriter _classWriter;
        this.cwriter = _classWriter = new ClassWriter(3);
        if (isDebug) {
            PrintWriter _printWriter = new PrintWriter(System.err);
            TraceClassVisitor _traceClassVisitor = new TraceClassVisitor((ClassVisitor)this.cwriter, _printWriter);
            this.tcvisitor = _traceClassVisitor;
        } else {
            this.tcvisitor = this.cwriter;
        }
        this.classEntity = classEntity;
        this.classEntity.setCwriter(this.cwriter);
        this.tcvisitor.visit(version, access, classEntity.getFullName(), null, classEntity.getSuperclass(), classEntity.getInterfaces());
    }

    public static CreateClass Class(ClassEntity classEntity) {
        int _version = classEntity.getVersion();
        return new CreateClass(classEntity, _version, 1, false);
    }

    public static CreateClass Class(ClassEntity classEntity, boolean isDebug) {
        int _version = classEntity.getVersion();
        return new CreateClass(classEntity, _version, 1, isDebug);
    }

    public static CreateClass Class(ClassEntity classEntity, int version, boolean isDebug) {
        return new CreateClass(classEntity, version, 1, isDebug);
    }

    public static CreateClass Class(ClassEntity classEntity, int version) {
        return new CreateClass(classEntity, version, 1);
    }

    public static CreateClass Interface(ClassEntity classEntity, int version) {
        return new CreateClass(classEntity, version, 1537);
    }

    public static CreateClass Abstract(ClassEntity classEntity, int version) {
        return new CreateClass(classEntity, version, 1025);
    }

    public void field(FieldEntity field) {
        this.tcvisitor.visitField(field.getAccess(), field.getName(), field.getDescriptor(), null, field.getValue()).visitEnd();
    }

    public CreateClass constructor(Constructor<?>[] constructor) {
        Consumer<Constructor> _function = it -> {
            boolean _greaterThan;
            Method m = Method.getMethod((Constructor)it);
            GeneratorAdapter ga = new GeneratorAdapter(1, m, null, null, this.tcvisitor);
            ga.loadThis();
            int _size = ((List)Conversions.doWrapArray((Object)it.getParameters())).size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                int _size_1 = ((List)Conversions.doWrapArray((Object)it.getParameters())).size();
                int _minus = _size_1 - 1;
                ga.loadArgs(0, _minus);
            }
            ga.invokeConstructor(Type.getObjectType((String)this.classEntity.getSuperclass()), m);
            ga.returnValue();
            ga.endMethod();
        };
        IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray(constructor))).forEach(_function);
        return this;
    }

    public CreateMethod method(MethodEntity method) {
        GeneratorAdapter _generatorAdapter;
        int _access = method.getAccess();
        Method _method = Method.getMethod((String)method.getDefineMethod(), (boolean)method.isDefaultPackage());
        this.ga = _generatorAdapter = new GeneratorAdapter(_access, _method, null, null, this.tcvisitor);
        return new CreateMethod(this.classEntity, this.ga);
    }

    public CreateClass end() {
        try {
            this.tcvisitor.visitEnd();
            this.bytecode = this.cwriter.toByteArray();
            String _packageName = this.classEntity.getPackageName();
            String _plus = _packageName + ".";
            String _className = this.classEntity.getClassName();
            String _plus_1 = _plus + _className;
            File temp = File.createTempFile(_plus_1, ".class");
            FileUtils.writeByteArrayToFile((File)temp, (byte[])this.bytecode);
            return this;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public byte[] toByteArray() {
        return this.bytecode;
    }

    @Override
    public Class<?> findClass(String name) {
        LOG.info("\u6267\u884cfindClass:{}", (Object)name);
        return super.defineClass(name, this.bytecode, 0, this.bytecode.length);
    }
}

