/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.ioc.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import cool.taomu.box.asm.CreateClass;
import cool.taomu.box.asm.CreateMethod;
import cool.taomu.box.asm.entity.ClassEntity;
import cool.taomu.box.asm.entity.MethodEntity;
import cool.taomu.box.ioc.ann.Binders;
import cool.taomu.box.ioc.ann.BindersImpl;
import cool.taomu.box.ioc.ann.Guice;
import cool.taomu.box.ioc.ann.Mybatis;
import cool.taomu.box.ioc.entity.BindersEntity;
import cool.taomu.box.ioc.entity.InterceptorEntity;
import cool.taomu.box.ioc.util.TaomuGuiceUitl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.mybatis.guice.MyBatisModule;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Accessors
@SuppressWarnings("all")
public class TaomuGuiceModule {
  private static final Logger LOG = LoggerFactory.getLogger(TaomuGuiceModule.class);
  
  private boolean isDebug = false;
  
  private static final HashMap<String, ClassLoader> ccloader = new HashMap<String, ClassLoader>();
  
  public static Class<?> loadZlass(final String name) {
    try {
      TaomuGuiceModule.LOG.info("load Class:{}", name);
      boolean _containsKey = TaomuGuiceModule.ccloader.containsKey(name);
      if (_containsKey) {
        TaomuGuiceModule.LOG.info("get Class:{}", name);
        ClassLoader cl = TaomuGuiceModule.ccloader.get(name);
        String clname = name;
        TaomuGuiceModule.LOG.info("get cl Class:{}", clname);
        InputOutput.<String>println(cl.getClass().getName());
        return cl.loadClass(clname);
      } else {
        return Thread.currentThread().getContextClassLoader().loadClass(name);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public AbstractModule build(final List<InterceptorEntity> ir) {
    return new AbstractModule() {
      @Override
      public void configure() {
        final Binder binder = this.binder();
        final Consumer<InterceptorEntity> _function = (InterceptorEntity it) -> {
          binder.bindInterceptor(it.getClassMatcher(), it.getMethodMatcher(), it.getInterceptors());
        };
        IterableExtensions.<InterceptorEntity>filterNull(ir).forEach(_function);
      }
    };
  }
  
  public com.google.inject.Module build(final Class<?>... zlasses) throws CreationException {
    try {
      final LinkedList<BindersEntity> cacheBinders = new LinkedList<BindersEntity>();
      final LinkedList<Class<? extends com.google.inject.Module>> cacheModule = new LinkedList<Class<? extends com.google.inject.Module>>();
      final ArrayList<Class<? extends com.google.inject.Module>> modules = new ArrayList<Class<? extends com.google.inject.Module>>();
      final Procedure2<Class<?>, Integer> _function = (Class<?> zlass, Integer i) -> {
        TaomuGuiceModule.LOG.info("配置类：{}", zlass.getName());
        if (((IterableExtensions.<Class<?>>findFirst(((Iterable<Class<?>>)Conversions.doWrapArray(zlass.getInterfaces())), ((Function1<Class<?>, Boolean>) (Class<?> it) -> {
          return Boolean.valueOf(it.equals(com.google.inject.Module.class));
        })) != null) || zlass.getSuperclass().equals(AbstractModule.class))) {
          modules.add(((Class<? extends com.google.inject.Module>) zlass));
        }
        final Guice box = zlass.<Guice>getAnnotation(Guice.class);
        final Binders binders = zlass.<Binders>getAnnotation(Binders.class);
        final cool.taomu.box.ioc.ann.Binder binder = zlass.<cool.taomu.box.ioc.ann.Binder>getAnnotation(cool.taomu.box.ioc.ann.Binder.class);
        if ((box != null)) {
          final Consumer<Binders> _function_1 = (Binders it) -> {
            cacheBinders.add(TaomuGuiceUitl.toBinders(it));
          };
          ((List<Binders>)Conversions.doWrapArray(box.value())).forEach(_function_1);
        } else {
          if ((binders != null)) {
            BindersEntity bs = TaomuGuiceUitl.toBinders(binders);
            cacheBinders.add(bs);
          } else {
            if ((binder != null)) {
              BindersImpl _bindersImpl = new BindersImpl(new cool.taomu.box.ioc.ann.Binder[] { binder });
              BindersEntity tgb = TaomuGuiceUitl.toBinders(_bindersImpl);
              cacheBinders.add(tgb);
            }
          }
        }
        Mybatis mybatis = zlass.<Mybatis>getAnnotation(Mybatis.class);
        if ((mybatis != null)) {
          Class<? extends com.google.inject.Module> module = this.mybatisModule(mybatis.scanMapper(), mybatis.provider());
          modules.add(((Class<? extends com.google.inject.Module>) module));
        }
      };
      IterableExtensions.<Class<?>>forEach(IterableExtensions.<Class<?>>filterNull(((Iterable<Class<?>>)Conversions.doWrapArray(zlasses))), _function);
      int _size = cacheBinders.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        final Procedure2<BindersEntity, Integer> _function_1 = (BindersEntity it, Integer i) -> {
          cacheModule.add(this.buildModule(it, this.isDebug));
        };
        IterableExtensions.<BindersEntity>forEach(cacheBinders, _function_1);
      }
      int _size_1 = cacheModule.size();
      boolean _greaterThan_1 = (_size_1 > 0);
      if (_greaterThan_1) {
        String name = UUID.randomUUID().toString().replace("-", "");
        String moduleName = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("Taomu", name, "BaseModule")), "");
        ClassEntity classEntity = new ClassEntity("cool.taomu.box", moduleName);
        classEntity.setSuperclass(Type.getType(AbstractModule.class).getInternalName());
        CreateClass cc = CreateClass.Class(classEntity, Opcodes.V1_8, this.isDebug);
        cc.constructor(AbstractModule.class.getConstructors());
        MethodEntity methodEntity = new MethodEntity("void configure()");
        MethodEntity binder = new MethodEntity("com/google/inject/Binder binder()", true);
        final CreateMethod cm = cc.method(methodEntity).This().invokeVirtual(binder).store("binder", Binder.class);
        final Consumer<Class<? extends com.google.inject.Module>> _function_2 = (Class<? extends com.google.inject.Module> it) -> {
          TaomuGuiceModule.LOG.info("安装Module类：{}", it.getName());
          this.ginstall(cm, it);
        };
        IterableExtensions.<Class<? extends com.google.inject.Module>>filterNull(modules).forEach(_function_2);
        final Consumer<Class<? extends com.google.inject.Module>> _function_3 = (Class<? extends com.google.inject.Module> it) -> {
          TaomuGuiceModule.LOG.info("安装Module类：{}", it.getName());
          this.ginstall(cm, it);
        };
        cacheModule.forEach(_function_3);
        cm.returnValue().endMethod();
        cc.end();
        String key = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("cool.taomu.box", moduleName)), ".");
        TaomuGuiceModule.ccloader.put(key, cc);
        Class<?> _loadClass = cc.loadClass(key);
        return ((Class<com.google.inject.Module>) _loadClass).newInstance();
      }
      return null;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private CreateMethod ginstall(final CreateMethod cm, final Class<? extends com.google.inject.Module> zlass) {
    CreateMethod _xblockexpression = null;
    {
      cm.ldc(zlass.getName());
      String _replace = TaomuGuiceModule.class.getName().replace(".", "/");
      MethodEntity _methodEntity = new MethodEntity(_replace, "java/lang/Class loadZlass(java/lang/String)", 
        true);
      cm.invokeStatic(_methodEntity);
      MethodEntity _methodEntity_1 = new MethodEntity("java/lang/Class", "java/lang/Object newInstance()", true);
      cm.invokeVirtual(_methodEntity_1);
      cm.store(zlass.getName(), Object.class);
      cm.load("binder");
      cm.load(zlass.getName());
      cm.checkCast(com.google.inject.Module.class);
      MethodEntity _methodEntity_2 = new MethodEntity("com/google/inject/Binder", "void install(com/google/inject/Module)", true);
      _xblockexpression = cm.invokeInterface(_methodEntity_2);
    }
    return _xblockexpression;
  }
  
  private Class<? extends com.google.inject.Module> hibrnateModule(final String mapper, final Class<? extends Provider<DataSource>> provider) {
    return null;
  }
  
  private Class<? extends com.google.inject.Module> mybatisModule(final String mapper, final Class<? extends Provider<DataSource>> provider) {
    try {
      String name = UUID.randomUUID().toString().replace("-", "");
      String moduleName = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("TaomuMybatis", name, "Module")), "");
      ClassEntity classEntity = new ClassEntity("cool.taomu.box", moduleName);
      classEntity.setSuperclass(Type.getType(MyBatisModule.class).getInternalName());
      CreateClass cc = CreateClass.Class(classEntity, Opcodes.V1_8, this.isDebug);
      cc.constructor(AbstractModule.class.getConstructors());
      MethodEntity methodEntity = new MethodEntity("void initialize()");
      methodEntity.setAccess(Opcodes.ACC_PROTECTED);
      CreateMethod cm = cc.method(methodEntity);
      MethodEntity bindDataSourceProviderType = new MethodEntity("org/mybatis/guice/MyBatisModule", 
        "void bindDataSourceProviderType (java/lang/Class)", true);
      MethodEntity bindTransactionFactoryType = new MethodEntity("org/mybatis/guice/MyBatisModule", 
        "void bindTransactionFactoryType (java/lang/Class)", true);
      cm.This().ldc(provider.getName());
      String _replace = TaomuGuiceModule.class.getName().replace(".", "/");
      MethodEntity _methodEntity = new MethodEntity(_replace, "java/lang/Class loadZlass(java/lang/String)", 
        true);
      cm.invokeStatic(_methodEntity);
      cm.store("datasource", Class.class);
      cm.load("datasource");
      cm.store("datasource2", Class.class);
      cm.This().load("datasource2");
      cm.invokeSpecial(bindDataSourceProviderType);
      cm.This().ldc(JdbcTransactionFactory.class.getName());
      String _replace_1 = TaomuGuiceModule.class.getName().replace(".", "/");
      MethodEntity _methodEntity_1 = new MethodEntity(_replace_1, "java/lang/Class loadZlass(java/lang/String)", 
        true);
      cm.invokeStatic(_methodEntity_1);
      cm.store("JdbcTransactionFactory", Class.class);
      cm.load("JdbcTransactionFactory");
      cm.store("JdbcTransactionFactory2", Class.class);
      cm.This().load("JdbcTransactionFactory2");
      cm.invokeSpecial(bindTransactionFactoryType);
      MethodEntity addMapperClasses = new MethodEntity("org/mybatis/guice/MyBatisModule", 
        "void addMapperClasses (java/lang/String)", true);
      cm.This().ldc(mapper).invokeSpecial(addMapperClasses);
      cm.returnValue().endMethod();
      cc.end();
      String key = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("cool.taomu.box", moduleName)), ".");
      TaomuGuiceModule.ccloader.put(key, cc);
      TaomuGuiceModule.LOG.info("end");
      Class<?> _loadClass = cc.loadClass(key);
      return ((Class<com.google.inject.Module>) _loadClass);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private Class<? extends com.google.inject.Module> buildModule(final BindersEntity binders, final boolean isDebug) {
    try {
      if ((binders != null)) {
        String name = UUID.randomUUID().toString().replace("-", "");
        String moduleName = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("Taomu", name, "Module")), "");
        ClassEntity classEntity = new ClassEntity("cool.taomu.box", moduleName);
        classEntity.setSuperclass(Type.getType(AbstractModule.class).getInternalName());
        CreateClass cc = CreateClass.Class(classEntity, Opcodes.V1_8, isDebug);
        cc.constructor(AbstractModule.class.getConstructors());
        MethodEntity methodEntity = new MethodEntity("void configure()");
        MethodEntity binder = new MethodEntity("com/google/inject/Binder binder()", true);
        final CreateMethod cm = cc.method(methodEntity).This().invokeVirtual(binder).store("binder", Binder.class);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(binders.getProperties());
        boolean _not = (!_isNullOrEmpty);
        if (_not) {
          cm.load("binder");
          cm.ldc(binders.getProperties());
          MethodEntity _methodEntity = new MethodEntity("cool/taomu/box/ioc/util/PropertyUtils", 
            "java/util/Properties load(java/lang/String)", true);
          cm.invokeStatic(_methodEntity);
          MethodEntity _methodEntity_1 = new MethodEntity("com/google/inject/name/Names", 
            "void bindProperties(com/google/inject/Binder,java/util/Properties)", true);
          cm.invokeStatic(_methodEntity_1);
        }
        if (((binders.getInstalls() != null) && (((List<Class<? extends com.google.inject.Module>>)Conversions.doWrapArray(binders.getInstalls())).size() > 0))) {
          final Consumer<Class<? extends com.google.inject.Module>> _function = (Class<? extends com.google.inject.Module> it) -> {
            cm.NEW(it);
            cm.dup();
            String _name = it.getName();
            MethodEntity _methodEntity_2 = new MethodEntity(_name, "void <init>()");
            cm.invokeSpecial(_methodEntity_2);
            cm.store(it.getName(), it);
            cm.load("binder");
            cm.load(it.getName());
            MethodEntity _methodEntity_3 = new MethodEntity("com/google/inject/Binder", "void install(com/google/inject/Module)", true);
            cm.invokeInterface(_methodEntity_3);
          };
          ((List<Class<? extends com.google.inject.Module>>)Conversions.doWrapArray(binders.getInstalls())).forEach(_function);
        }
        BinderRule.rule(cm, binders.getValues(), TaomuGuiceModule.ccloader);
        cm.returnValue().endMethod();
        cc.end();
        String key = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("cool.taomu.box", moduleName)), ".");
        TaomuGuiceModule.ccloader.put(key, cc);
        TaomuGuiceModule.LOG.info("end");
        Class<?> _loadClass = cc.loadClass(key);
        return ((Class<com.google.inject.Module>) _loadClass);
      }
      return null;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Pure
  public boolean isDebug() {
    return this.isDebug;
  }
  
  public void setIsDebug(final boolean isDebug) {
    this.isDebug = isDebug;
  }
}
