package cool.taomu.box.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

@SuppressWarnings("all")
public class JdbcProxyDriver implements Driver {
  @Override
  public boolean acceptsURL(final String url) throws SQLException {
    return ((url != null) && url.startsWith("jdbc:proxy"));
  }
  
  @Override
  public Connection connect(final String url, final Properties info) throws SQLException {
    boolean _acceptsURL = this.acceptsURL(url);
    boolean _not = (!_acceptsURL);
    if (_not) {
      return null;
    }
    String nurl = url.replace("jdbc:proxy", "jdbc");
    Connection realConnection = DriverManager.getConnection(nurl, info);
    return realConnection;
  }
  
  @Override
  public int getMajorVersion() {
    return 1;
  }
  
  @Override
  public int getMinorVersion() {
    return 0;
  }
  
  @Override
  public Logger getParentLogger() throws SQLFeatureNotSupportedException {
    throw new SQLFeatureNotSupportedException();
  }
  
  @Override
  public DriverPropertyInfo[] getPropertyInfo(final String url, final Properties info) throws SQLException {
    return new DriverPropertyInfo[0];
  }
  
  @Override
  public boolean jdbcCompliant() {
    return true;
  }
}
