package cool.taomu.box.jdbc;

import com.google.common.base.Function;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public class JdbcProxyHandler implements InvocationHandler {
  @Accessors
  public static class JdbcProxyEntity {
    private Object target;
    
    private Method method;
    
    private Object[] args;
    
    public JdbcProxyEntity(final Object target, final Method method, final Object[] args) {
      this.target = target;
      this.method = method;
      this.args = args;
    }
    
    @Pure
    public Object getTarget() {
      return this.target;
    }
    
    public void setTarget(final Object target) {
      this.target = target;
    }
    
    @Pure
    public Method getMethod() {
      return this.method;
    }
    
    public void setMethod(final Method method) {
      this.method = method;
    }
    
    @Pure
    public Object[] getArgs() {
      return this.args;
    }
    
    public void setArgs(final Object[] args) {
      this.args = args;
    }
  }
  
  private final Object target;
  
  private final Function<JdbcProxyHandler.JdbcProxyEntity, Object> func;
  
  public JdbcProxyHandler(final Object target, final Function<JdbcProxyHandler.JdbcProxyEntity, Object> func) {
    this.target = target;
    this.func = func;
  }
  
  @Override
  public Object invoke(final Object proxy, final Method method, final Object[] args) throws Throwable {
    try {
      if ((this.func != null)) {
        JdbcProxyHandler.JdbcProxyEntity _jdbcProxyEntity = new JdbcProxyHandler.JdbcProxyEntity(this.target, method, args);
        return this.func.apply(_jdbcProxyEntity);
      } else {
        return method.invoke(this.target, args);
      }
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        throw e;
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  @SuppressWarnings("unchecked")
  public static <T extends Object> T createProxy(final T target, final Function<JdbcProxyHandler.JdbcProxyEntity, Object> func) {
    Class<?>[] is = target.getClass().getInterfaces();
    int _length = is.length;
    boolean _equals = (_length == 0);
    if (_equals) {
      Class<?> supClass = target.getClass().getSuperclass();
      while ((supClass.getInterfaces().length == 0)) {
        supClass = supClass.getSuperclass();
      }
      is = supClass.getInterfaces();
    }
    ClassLoader _classLoader = target.getClass().getClassLoader();
    JdbcProxyHandler _jdbcProxyHandler = new JdbcProxyHandler(target, func);
    Object _newProxyInstance = Proxy.newProxyInstance(_classLoader, is, _jdbcProxyHandler);
    return ((T) _newProxyInstance);
  }
}
