package cool.taomu.box.jersery.tomcat;



import org.apache.catalina.Server;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.servlet.ServletModule;

import cool.taomu.box.jersery.JerseryGuiceInjector;

public class JerseyTomcatModule extends AbstractModule {

	protected void configure() {
		Provider<Injector> injectorProvider = getProvider(Injector.class);
		install(new ServletModule());
		JerseryGuiceInjector jgi = new JerseryGuiceInjector();
		jgi.setInjectorSupplier(injectorProvider::get);
		bind(JerseryGuiceInjector.class).toInstance(jgi);
		bind(Server.class).toProvider(TomcatProvider.class);
	}

}
