/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.jersery;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.jvnet.hk2.guice.bridge.api.GuiceBridge;
import org.jvnet.hk2.guice.bridge.api.GuiceIntoHK2Bridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class GuiceResourceConfig extends ResourceConfig {
  private static final Logger LOG = LoggerFactory.getLogger(GuiceResourceConfig.class);
  
  public GuiceResourceConfig() {
    super();
  }
  
  @Inject
  public GuiceResourceConfig(final ServiceLocator serviceLocator, final ServletContext servletContext) {
    Object _attribute = servletContext.getAttribute(Injector.class.getName());
    Injector injector = ((Injector) _attribute);
    String pk = injector.<String>getInstance(Key.<String>get(String.class, Names.named("jersery.packages")));
    GuiceResourceConfig.LOG.info("packages:{}", pk);
    this.packages(pk.split(","));
    String tmpPath = injector.<String>getInstance(Key.<String>get(String.class, Names.named("jersery.template.path")));
    tmpPath = StringUtils.<String>defaultIfBlank(tmpPath, "templates/freemarker");
    this.property(FreemarkerMvcFeature.TEMPLATE_BASE_PATH, tmpPath);
    this.register(FreemarkerMvcFeature.class);
    GuiceBridge.getGuiceBridge().initializeGuiceBridge(serviceLocator);
    GuiceIntoHK2Bridge guiceBridge = serviceLocator.<GuiceIntoHK2Bridge>getService(GuiceIntoHK2Bridge.class);
    guiceBridge.bridgeGuiceInjector(injector);
  }
}
