/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.jersery.jetty;


import org.eclipse.jetty.server.Server;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.servlet.ServletModule;

import cool.taomu.box.jersery.JerseryGuiceInjector;

public class JerseyJettyModule extends AbstractModule {

	protected void configure() {
		Provider<Injector> injectorProvider = getProvider(Injector.class);
		install(new ServletModule());
		JerseryGuiceInjector jgi = new JerseryGuiceInjector();
		jgi.setInjectorSupplier(injectorProvider::get);
		bind(JerseryGuiceInjector.class).toInstance(jgi);
		bind(Server.class).toProvider(JettyProvider.class);
	}

}
