/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.jersery.jetty;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import cool.taomu.box.jersery.GuiceResourceConfig;
import cool.taomu.box.jersery.JerseryGuiceInjector;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import javax.inject.Provider;
import javax.servlet.DispatcherType;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyProvider
implements Provider<Server> {
    private static final Logger LOG = LoggerFactory.getLogger(JettyProvider.class);
    @Inject(optional=true)
    @Named(value="resourceConfig")
    private String resourceConfig = GuiceResourceConfig.class.getName();
    @Inject(optional=true)
    @Named(value="taomubox.http.name")
    private String name;
    @Inject(optional=true)
    @Named(value="taomubox.http.host")
    private String host = "0.0.0.0";
    @Inject(optional=true)
    @Named(value="taomubox.http.port")
    private int port = 8080;
    @Inject(optional=true)
    @Named(value="taomubox.http.path")
    private String contextPath = "/";
    @Inject(optional=true)
    @Named(value="taomubox.http.static.path")
    private String staticBasePath = null;
    @Inject(optional=true)
    @Named(value="taomubox.http.pathSpec")
    private String pathSpec = "";
    private HttpConfiguration httpConfiguration = new HttpConfiguration();
    private Server server;
    @Inject
    private JerseryGuiceInjector supplier;

    public Server get() {
        Server _server;
        boolean _not;
        Server _xblockexpression = null;
        boolean _startsWith = this.contextPath.startsWith("/");
        boolean bl = _not = !_startsWith;
        if (_not) {
            this.contextPath = "/" + this.contextPath;
        }
        if (this.name == null || this.name.equals("")) {
            this.name = String.format("%s-%s", this.host, this.port);
        }
        this.server = _server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setName(this.name);
        connector.setHost(this.host);
        connector.setPort(this.port);
        HttpConnectionFactory _httpConnectionFactory = new HttpConnectionFactory(this.httpConfiguration);
        connector.setConnectionFactories(Collections.singleton(_httpConnectionFactory));
        this.server.addConnector((Connector)connector);
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setServer(this.server);
        webAppContext.addFilter(GuiceFilter.class, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{this.pathSpec, "/*"})), (CharSequence)""), EnumSet.allOf(DispatcherType.class));
        ServletHolder holder = new ServletHolder(ServletContainer.class);
        holder.setInitParameter("javax.ws.rs.Application", this.resourceConfig);
        webAppContext.addServlet(holder, IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{this.pathSpec, "/*"})), (CharSequence)""));
        webAppContext.setResourceBase("/");
        webAppContext.setContextPath(this.contextPath);
        webAppContext.addEventListener((EventListener)new GuiceServletContextListener(){

            protected Injector getInjector() {
                return JettyProvider.this.supplier.getInjectorSupplier().get();
            }
        });
        ServletHolder defaultServlet = new ServletHolder("default", DefaultServlet.class);
        String _property = System.getProperty("user.dir");
        String _defaultIfBlank = (String)StringUtils.defaultIfBlank((CharSequence)this.staticBasePath, (CharSequence)"static");
        String staticDir = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_property, _defaultIfBlank})), (CharSequence)"/");
        LOG.info("web static file directory : {}", (Object)staticDir);
        defaultServlet.setInitParameter("resourceBase", staticDir);
        webAppContext.addServlet(defaultServlet, "/static/*");
        JettyProvider.setHandler((HandlerWrapper)this.server, (Handler)webAppContext);
        _xblockexpression = this.server;
        return _xblockexpression;
    }

    public static void setHandler(HandlerWrapper handlerWrapper, Handler handlerToAdd) {
        Handler currentInnerHandler = handlerWrapper.getHandler();
        if (currentInnerHandler == null) {
            handlerWrapper.setHandler(handlerToAdd);
        } else if (currentInnerHandler instanceof HandlerCollection) {
            ((HandlerCollection)currentInnerHandler).addHandler(handlerToAdd);
        } else if (currentInnerHandler instanceof HandlerWrapper) {
            JettyProvider.setHandler((HandlerWrapper)currentInnerHandler, handlerToAdd);
        } else {
            HandlerList handlerList = new HandlerList();
            handlerList.addHandler(currentInnerHandler);
            handlerList.addHandler(handlerToAdd);
            handlerWrapper.setHandler((Handler)handlerWrapper);
        }
    }
}

