/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.jersery.tomcat;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import cool.taomu.box.jersery.JerseryGuiceInjector;
import java.io.File;
import javax.inject.Provider;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.Wrapper;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class TomcatProvider implements Provider<Server> {
  public static class A extends GuiceServletContextListener {
    public A() {
    }
    
    public static JerseryGuiceInjector supplier;
    
    @Override
    protected Injector getInjector() {
      return TomcatProvider.A.supplier.getInjectorSupplier().get();
    }
  }
  
  @Inject
  @Named("resourceConfig")
  private String resourceConfig;
  
  @Inject(optional = true)
  @Named("name")
  private String name;
  
  @Inject(optional = true)
  @Named("host")
  private String host = "0.0.0.0";
  
  @Inject(optional = true)
  @Named("port")
  private int port = 8080;
  
  @Inject(optional = true)
  @Named("path")
  private String contextPath = "/";
  
  private final Tomcat tomcat = new Tomcat();
  
  @Inject
  private JerseryGuiceInjector supplier;
  
  @Override
  public Server get() {
    try {
      Server _xblockexpression = null;
      {
        boolean _startsWith = this.contextPath.startsWith("/");
        boolean _not = (!_startsWith);
        if (_not) {
          this.contextPath = ("/" + this.contextPath);
        }
        if (((this.name == null) || this.name.equals(""))) {
          this.name = String.format("%s-%s", this.host, Integer.valueOf(this.port));
        }
        Runtime _runtime = Runtime.getRuntime();
        final Runnable _function = () -> {
          try {
            this.tomcat.destroy();
          } catch (final Throwable _t) {
            if (_t instanceof LifecycleException) {
              final LifecycleException e = (LifecycleException)_t;
              e.printStackTrace();
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
        };
        Thread _thread = new Thread(_function);
        _runtime.addShutdownHook(_thread);
        this.tomcat.setHostname(this.host);
        this.tomcat.setPort(this.port);
        this.tomcat.setBaseDir("./src/main");
        this.tomcat.getConnector();
        String _property = System.getProperty("java.io.tmpdir");
        File base = new File(_property);
        Context ctx = this.tomcat.addWebapp("/", ".");
        ctx.setReloadable(false);
        FilterDef filter = new FilterDef();
        filter.setFilterName("guiceFilter");
        filter.setFilterClass(GuiceFilter.class.getName());
        ctx.addFilterDef(filter);
        FilterMap filterMap = new FilterMap();
        filterMap.addURLPattern("/*");
        filterMap.setFilterName("guiceFilter");
        ctx.addFilterMap(filterMap);
        filter.addInitParameter("javax.ws.rs.Application", this.resourceConfig);
        TomcatProvider.A.supplier = this.supplier;
        ctx.addApplicationListener(TomcatProvider.A.class.getName());
        Wrapper wrapper = Tomcat.addServlet(ctx, "base", "org.glassfish.jersey.servlet.ServletContainer");
        wrapper.addMapping("/*");
        wrapper.addInitParameter("javax.ws.rs.Application", this.resourceConfig);
        this.tomcat.start();
        _xblockexpression = this.tomcat.getServer();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
