/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.jersery.jetty;

import javax.inject.Inject;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class JsereyJettyServer {
  private static final Logger LOG = LoggerFactory.getLogger(JsereyJettyServer.class);
  
  @Inject
  private Server server;
  
  public void start() throws Exception {
    JsereyJettyServer.LOG.info("Starting embedded jetty server");
    this.server.start();
    this.server.join();
  }
  
  public void stop() throws Exception {
    this.server.stop();
    JsereyJettyServer.LOG.info("Embedded jetty server stopped");
  }
}
