/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.jersery.tomcat;

import javax.inject.Inject;
import org.apache.catalina.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class JsereyTomcatServer {
  private static final Logger LOG = LoggerFactory.getLogger(JsereyTomcatServer.class);
  
  @Inject
  private Server server;
  
  public void start() throws Exception {
    JsereyTomcatServer.LOG.info("Starting embedded tomcat server");
    this.server.await();
  }
  
  public void stop() throws Exception {
    this.server.stop();
    JsereyTomcatServer.LOG.info("Embedded tomcat server stopped");
  }
}
