package cool.taomu.box.jersery.jetty;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import cool.taomu.box.jersery.GuiceResourceConfig;
import cool.taomu.box.jersery.JerseryGuiceInjector;
import java.util.Collections;
import java.util.EnumSet;
import javax.inject.Provider;
import javax.servlet.DispatcherType;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.glassfish.jersey.servlet.ServletContainer;

@SuppressWarnings("all")
public class JettyProvider implements Provider<Server> {
  @Inject(optional = true)
  @Named("resourceConfig")
  private String resourceConfig = GuiceResourceConfig.class.getName();
  
  @Inject(optional = true)
  @Named("taomubox.http.name")
  private String name;
  
  @Inject(optional = true)
  @Named("taomubox.http.host")
  private String host = "0.0.0.0";
  
  @Inject(optional = true)
  @Named("taomubox.http.port")
  private int port = 8080;
  
  @Inject(optional = true)
  @Named("taomubox.http.path")
  private String contextPath = "/";
  
  @Inject(optional = true)
  @Named("taomubox.http.static.path")
  private String staticBasePath = null;
  
  private HttpConfiguration httpConfiguration = new HttpConfiguration();
  
  private Server server;
  
  @Inject
  private JerseryGuiceInjector supplier;
  
  @Override
  public Server get() {
    Server _xblockexpression = null;
    {
      boolean _startsWith = this.contextPath.startsWith("/");
      boolean _not = (!_startsWith);
      if (_not) {
        this.contextPath = ("/" + this.contextPath);
      }
      if (((this.name == null) || this.name.equals(""))) {
        this.name = String.format("%s-%s", this.host, Integer.valueOf(this.port));
      }
      Server _server = new Server();
      this.server = _server;
      ServerConnector connector = new ServerConnector(this.server);
      connector.setName(this.name);
      connector.setHost(this.host);
      connector.setPort(this.port);
      HttpConnectionFactory _httpConnectionFactory = new HttpConnectionFactory(this.httpConfiguration);
      connector.setConnectionFactories(Collections.<ConnectionFactory>singleton(_httpConnectionFactory));
      this.server.addConnector(connector);
      WebAppContext webAppContext = new WebAppContext();
      webAppContext.setServer(this.server);
      webAppContext.addFilter(GuiceFilter.class, "/*", EnumSet.<DispatcherType>allOf(DispatcherType.class));
      ServletHolder holder = new ServletHolder(ServletContainer.class);
      holder.setInitParameter("javax.ws.rs.Application", this.resourceConfig);
      webAppContext.addServlet(holder, "/*");
      webAppContext.setResourceBase("/");
      InputOutput.<String>println(webAppContext.getResourceBase());
      webAppContext.setContextPath(this.contextPath);
      webAppContext.addEventListener(new GuiceServletContextListener() {
        @Override
        protected Injector getInjector() {
          return JettyProvider.this.supplier.getInjectorSupplier().get();
        }
      });
      ServletHolder defaultServlet = new ServletHolder("default", DefaultServlet.class);
      boolean _startsWith_1 = this.staticBasePath.startsWith("/");
      boolean _not_1 = (!_startsWith_1);
      if (_not_1) {
        String _property = System.getProperty("user.dir");
        this.staticBasePath = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_property, this.staticBasePath)), "/");
      }
      String _property_1 = System.getProperty("user.dir");
      String staticDir = StringUtils.<String>defaultIfEmpty(this.staticBasePath, 
        IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_property_1, "src/test/resources")), "/"));
      defaultServlet.setInitParameter(
        "resourceBase", staticDir);
      webAppContext.addServlet(defaultServlet, "/static/*");
      JettyProvider.setHandler(this.server, webAppContext);
      _xblockexpression = this.server;
    }
    return _xblockexpression;
  }
  
  public static void setHandler(final HandlerWrapper handlerWrapper, final Handler handlerToAdd) {
    Handler currentInnerHandler = handlerWrapper.getHandler();
    if ((currentInnerHandler == null)) {
      handlerWrapper.setHandler(handlerToAdd);
    } else {
      if ((currentInnerHandler instanceof HandlerCollection)) {
        ((HandlerCollection) currentInnerHandler).addHandler(handlerToAdd);
      } else {
        if ((currentInnerHandler instanceof HandlerWrapper)) {
          JettyProvider.setHandler(((HandlerWrapper) currentInnerHandler), handlerToAdd);
        } else {
          HandlerList handlerList = new HandlerList();
          handlerList.addHandler(currentInnerHandler);
          handlerList.addHandler(handlerToAdd);
          handlerWrapper.setHandler(handlerWrapper);
        }
      }
    }
  }
}
