package cool.taomu.box.jersery;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.jvnet.hk2.guice.bridge.api.GuiceBridge;
import org.jvnet.hk2.guice.bridge.api.GuiceIntoHK2Bridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class GuiceResourceConfig extends ResourceConfig {
  private static final Logger LOG = LoggerFactory.getLogger(GuiceResourceConfig.class);
  
  public GuiceResourceConfig() {
    super();
  }
  
  @Inject
  public GuiceResourceConfig(final ServiceLocator serviceLocator, final ServletContext servletContext) {
    Object _attribute = servletContext.getAttribute(Injector.class.getName());
    Injector injector = ((Injector) _attribute);
    String pk = injector.<String>getInstance(Key.<String>get(String.class, Names.named("jersery.packages")));
    GuiceResourceConfig.LOG.info("packages:{}", pk);
    this.packages(pk.split(","));
    String tmpPath = injector.<String>getInstance(Key.<String>get(String.class, Names.named("jersery.template.path")));
    tmpPath = StringUtils.<String>defaultIfBlank(tmpPath, "templates/freemarker");
    this.property(FreemarkerMvcFeature.TEMPLATE_BASE_PATH, tmpPath);
    this.register(FreemarkerMvcFeature.class);
    GuiceBridge.getGuiceBridge().initializeGuiceBridge(serviceLocator);
    GuiceIntoHK2Bridge guiceBridge = serviceLocator.<GuiceIntoHK2Bridge>getService(GuiceIntoHK2Bridge.class);
    guiceBridge.bridgeGuiceInjector(injector);
  }
}
