/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.client;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import cool.taomu.box.ioc.guice.TaomuGuiceModule;
import cool.taomu.box.jersery.jetty.JsereyJettyServer;
import cool.taomu.box.job.client.config.MqttClientConfig;
import cool.taomu.box.job.client.config.OAuth2Config;
import cool.taomu.box.paho.mqtt.client.TopicEntity;
import javax.inject.Inject;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class TaomuboxJobClient {
    @Inject
    private MqttClientConfig mqtt;
    @Inject
    private JsereyJettyServer jetty;

    public static void main(String[] args) {
        try {
            Module module = new TaomuGuiceModule().build(new Class[]{OAuth2Config.class, MqttClientConfig.class});
            Injector injector = Guice.createInjector((Module[])new Module[]{module});
            TaomuboxJobClient s = (TaomuboxJobClient)injector.getInstance(TaomuboxJobClient.class);
            s.jetty.start();
            TopicEntity _topicEntity = new TopicEntity();
            s.mqtt.getClient().subscriber(_topicEntity, (MqttCallback)s.mqtt.getCallback());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

