/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.client.config;

import com.google.inject.Inject;
import cool.taomu.box.ioc.ann.Binder;
import cool.taomu.box.ioc.ann.Binders;
import cool.taomu.box.ioc.entity.Scope;
import cool.taomu.box.job.client.impl.MqttClientCallback;
import cool.taomu.box.paho.mqtt.client.AbsMqttClientCallback;
import cool.taomu.box.paho.mqtt.client.MqttClientV3;
import cool.taomu.box.paho.mqtt.client.utils.ISerializationUtils;
import cool.taomu.box.paho.mqtt.client.utils.JavaSerializationUtils;
import cool.taomu.box.paho.mqtt.client.utils.MqttCrypto;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@Binders(properties = "client.yml", value = { @Binder(bind = ISerializationUtils.class, to = JavaSerializationUtils.class, in = Scope.SINGLETON), @Binder(bind = AbsMqttClientCallback.class, to = MqttClientCallback.class, in = Scope.SINGLETON), @Binder(bind = MqttCrypto.class), @Binder(to = MqttClientConfig.class, in = Scope.SINGLETON) })
@Accessors
@SuppressWarnings("all")
public class MqttClientConfig {
  @Inject
  private MqttClientV3 client;
  
  @Inject
  private AbsMqttClientCallback callback;
  
  @Pure
  public MqttClientV3 getClient() {
    return this.client;
  }
  
  public void setClient(final MqttClientV3 client) {
    this.client = client;
  }
  
  @Pure
  public AbsMqttClientCallback getCallback() {
    return this.callback;
  }
  
  public void setCallback(final AbsMqttClientCallback callback) {
    this.callback = callback;
  }
}
