/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.client.oauth2;

import cool.taomu.box.crypto.Sha1;
import cool.taomu.box.oltu.service.ClientService;
import java.net.URI;
import java.util.Collections;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @startuml
 * request -> code
 * @enduml
 */
@Path("job")
@SuppressWarnings("all")
public class OAuth2Callback {
  private static Logger log = LoggerFactory.getLogger(OAuth2Callback.class);
  
  @Inject
  private ClientService service;
  
  private String AUTH_SERVER_URL = "http://localhost:8080/server/oauth2/authServer/token";
  
  private static String CLIENT_ID = "29D1F902-B9DF-66A1-A52F-FF33BAC5C315";
  
  private static String CODE_URL = "code";
  
  private static String RESPONSE_TYPE = "code";
  
  private static String CALLBACKCODE = "http://localhost:8090/job/callback/code";
  
  /**
   * 资源拥有者地址
   */
  private static String RESOURCE_OWNER_URL = "http://localhost:8080/server/oauth2/owner/";
  
  @GET
  @Path("/getCode")
  public Response getCode() {
    try {
      OAuthClientRequest oAuthClientRequest = OAuthClientRequest.authorizationLocation(OAuth2Callback.CODE_URL).setClientId(OAuth2Callback.CLIENT_ID).setRedirectURI(OAuth2Callback.CALLBACKCODE).setResponseType(OAuth2Callback.RESPONSE_TYPE).buildQueryMessage();
      String uriString = oAuthClientRequest.getLocationUri();
      return Response.seeOther(URI.create((OAuth2Callback.RESOURCE_OWNER_URL + uriString))).build();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @GET
  @Path("/callback/code")
  public String callback(@QueryParam("code") final String code) {
    try {
      String clientId = "29D1F902-B9DF-66A1-A52F-FF33BAC5C315";
      String clientSecret = "29D1F902-B9DF-66A1-A52F-FF33BAC5C315";
      byte[] _bytes = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(code, clientSecret)), "###").getBytes();
      byte[] _encode = new Sha1(_bytes).encode();
      String newCode = new String(_encode, "UTF-8");
      OAuthJSONAccessTokenResponse tokenResp = this.service.requestToken(this.AUTH_SERVER_URL, null, newCode, clientId, clientSecret);
      String accessToken = tokenResp.getAccessToken();
      OAuth2Callback.log.info(("客户获取的访问令牌：" + accessToken));
      String _refreshToken = tokenResp.getRefreshToken();
      String _plus = ("客户获取的访问令牌：" + _refreshToken);
      OAuth2Callback.log.info(_plus);
      return accessToken;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
