/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.job.client.oauth2;

import cool.taomu.box.crypto.Sha1;
import cool.taomu.box.oltu.service.ClientService;
import java.net.URI;
import java.util.Collections;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="job")
public class OAuth2Callback {
    private static Logger log = LoggerFactory.getLogger(OAuth2Callback.class);
    @Inject
    private ClientService service;
    private String AUTH_SERVER_URL = "http://localhost:8080/server/oauth2/authServer/token";
    private static String CLIENT_ID = "29D1F902-B9DF-66A1-A52F-FF33BAC5C315";
    private static String CODE_URL = "code";
    private static String RESPONSE_TYPE = "code";
    private static String CALLBACKCODE = "http://localhost:8090/job/callback/code";
    private static String RESOURCE_OWNER_URL = "http://localhost:8080/server/oauth2/owner/";

    @GET
    @Path(value="/getCode")
    public Response getCode() {
        try {
            OAuthClientRequest oAuthClientRequest = OAuthClientRequest.authorizationLocation((String)CODE_URL).setClientId(CLIENT_ID).setRedirectURI(CALLBACKCODE).setResponseType(RESPONSE_TYPE).buildQueryMessage();
            String uriString = oAuthClientRequest.getLocationUri();
            return Response.seeOther((URI)URI.create(RESOURCE_OWNER_URL + uriString)).build();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @GET
    @Path(value="/callback/code")
    public String callback(@QueryParam(value="code") String code) {
        try {
            String clientId = "29D1F902-B9DF-66A1-A52F-FF33BAC5C315";
            String clientSecret = "29D1F902-B9DF-66A1-A52F-FF33BAC5C315";
            byte[] _bytes = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{code, clientSecret})), (CharSequence)"###").getBytes();
            byte[] _encode = new Sha1(_bytes).encode();
            String newCode = new String(_encode, "UTF-8");
            OAuthJSONAccessTokenResponse tokenResp = this.service.requestToken(this.AUTH_SERVER_URL, null, newCode, clientId, clientSecret);
            String accessToken = tokenResp.getAccessToken();
            log.info("\u5ba2\u6237\u83b7\u53d6\u7684\u8bbf\u95ee\u4ee4\u724c\uff1a" + accessToken);
            String _refreshToken = tokenResp.getRefreshToken();
            String _plus = "\u5ba2\u6237\u83b7\u53d6\u7684\u8bbf\u95ee\u4ee4\u724c\uff1a" + _refreshToken;
            log.info(_plus);
            return accessToken;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

