/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.client.config;

import com.google.inject.AbstractModule;
import cool.taomu.box.ioc.ann.Binder;
import cool.taomu.box.ioc.ann.Binders;
import cool.taomu.box.jersery.jetty.JerseyJettyModule;
import cool.taomu.box.jersery.jetty.JsereyJettyServer;

@Binders(properties = "client.yml", value = { @Binder(to = JsereyJettyServer.class), @Binder(named = "packages", value = "cool.taomu.box.job.client.oauth2") })
@SuppressWarnings("all")
public class OAuth2Config extends AbstractModule {
  @Override
  public void configure() {
    this.install(new JerseyJettyModule() {
      @Override
      protected void configureModule(final com.google.inject.Binder binder) {
      }
    });
  }
}
