/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.job.client;

import com.google.inject.Guice;
import com.google.inject.Injector;
import cool.taomu.box.ioc.guice.TaomuGuiceModule;
import cool.taomu.box.jersery.jetty.JsereyJettyServer;
import cool.taomu.box.job.client.config.MqttClientConfig;
import cool.taomu.box.job.client.config.OAuth2Config;
import cool.taomu.box.paho.mqtt.client.TopicEntity;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class TaomuboxJobClient {
  @Inject
  private MqttClientConfig mqtt;
  
  @Inject
  private JsereyJettyServer jetty;
  
  public static void main(final String[] args) {
    try {
      com.google.inject.Module module = new TaomuGuiceModule().build(OAuth2Config.class, MqttClientConfig.class);
      Injector injector = Guice.createInjector(module);
      TaomuboxJobClient s = injector.<TaomuboxJobClient>getInstance(TaomuboxJobClient.class);
      s.jetty.start();
      TopicEntity _topicEntity = new TopicEntity();
      s.mqtt.getClient().subscriber(_topicEntity, s.mqtt.getCallback());
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
