package cool.taomu.box.job.server.controller;

import cool.taomu.box.job.server.dao.TaskDao;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.FileUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.glassfish.jersey.server.mvc.ErrorTemplate;
import org.glassfish.jersey.server.mvc.Template;

@Path("job")
@SuppressWarnings("all")
public class IndexController {
  @Inject
  private TaskDao dao;
  
  @GET
  @Path("/{page}")
  @ErrorTemplate(name = "/error.ftl")
  @Template(name = "/main.ftl")
  @Produces(MediaType.TEXT_HTML)
  public Map<String, String> page(@PathParam("page") final String page) {
    try {
      HashMap<String, String> pcmap = new HashMap<String, String>();
      File _file = new File((("./template/" + page) + ".html"));
      pcmap.put("content", FileUtils.readFileToString(_file, "UTF-8"));
      File _file_1 = new File("./template/menu.html");
      pcmap.put("menu", FileUtils.readFileToString(_file_1, "UTF-8"));
      File _file_2 = new File("./template/navbar.html");
      pcmap.put("navbar", FileUtils.readFileToString(_file_2, "UTF-8"));
      return pcmap;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
