package cool.taomu.box.job.server.controller;

import cool.taomu.box.crypto.Base64;
import cool.taomu.box.crypto.Sha1;
import cool.taomu.box.job.server.dao.OAuth2UserDao;
import cool.taomu.box.job.server.entity.OAuth2UserEntity;
import cool.taomu.box.oltu.service.ServerService;
import cool.taomu.box.utils.DateTimeUtils;
import java.net.URI;
import java.util.Collections;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("/server/oauth2")
@SuppressWarnings("all")
public class OAuth2OwnerCode {
  private static Logger log = LoggerFactory.getLogger(OAuth2OwnerCode.class);
  
  @Inject
  private ServerService service;
  
  @Inject
  private OAuth2UserDao dao;
  
  @GET
  @Path("/owner/code")
  public Response sendCode(@Context final HttpServletRequest request) {
    OAuth2OwnerCode.log.info("resource owner send code");
    try {
      final ServerService.ICode _function = (String id) -> {
        try {
          long _dateTimeZoneTimestamp = DateTimeUtils.getDateTimeZoneTimestamp();
          String code = IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(id, Long.valueOf(_dateTimeZoneTimestamp))), "");
          byte[] _bytes = code.getBytes();
          byte[] _encode = new Base64(_bytes).encode();
          String resCode = new String(_encode, "UTF-8");
          this.dao.updateByClientId(resCode, id);
          return resCode;
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      String uri = this.service.OwnerCode(request, _function);
      return Response.seeOther(URI.create(uri)).build();
    } catch (final Throwable _t) {
      if (_t instanceof OAuthSystemException) {
        final OAuthSystemException e = (OAuthSystemException)_t;
        e.printStackTrace();
      } else if (_t instanceof OAuthProblemException) {
        final OAuthProblemException e_1 = (OAuthProblemException)_t;
        e_1.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return null;
  }
  
  @POST
  @Path("/authServer/token")
  public String getAccessToken(@Context final HttpServletRequest request) throws OAuthProblemException, OAuthSystemException {
    OAuth2OwnerCode.log.info("认证服务器，接收到客户的令牌请求 .... ");
    final ServerService.IToken _function = (String code, String id, String secret) -> {
      try {
        OAuth2UserEntity user = this.dao.selectByClientIdAndClientSecret(id, secret);
        String _code = user.getCode();
        byte[] _bytes = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_code, secret)), "###").getBytes();
        byte[] _encode = new Sha1(_bytes).encode();
        String newCode = new String(_encode, "UTF-8");
        if (((user != null) && newCode.equals(code))) {
          return true;
        }
        return false;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    };
    return this.service.getToken(request, _function);
  }
}
